% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pcoll_grid.R
\name{get_pcoll_grid}
\alias{get_pcoll_grid}
\title{Grid of probabilities of single transit collision at points in rotor circle}
\usage{
get_pcoll_grid(
  rotor_grids,
  direction,
  rotor_radius,
  blade_width,
  rotor_speed,
  blade_pitch,
  flight_type,
  n_blades,
  flight_speed,
  wing_span,
  body_lt
)
}
\arguments{
\item{rotor_grids}{A list object containing geometric attributes of the rotor
at equidistant points within its unit circle. This object should be
built via the function \code{generate_rotor_grids()}.}

\item{direction}{an integer, indicating the flight direction: 1 for upwind;
-1 for downwind.}

\item{rotor_radius}{Numeric value. The radius of the rotor (\eqn{R}), in
metres.}

\item{blade_width}{Numeric value, giving the maximum blade width, in metres.}

\item{rotor_speed}{Numeric value. The operational rotation speed, in
revolutions/min.}

\item{blade_pitch}{Numeric value. The average blade pitch angle, the angle
between the blade surface and the rotor plane (\eqn{\gamma}), in radians.}

\item{flight_type}{A character string, either 'flapping' or 'gliding',
indicating the species' characteristic flight type.}

\item{n_blades}{An integer, the number of blades in rotor (\eqn{b}).}

\item{flight_speed}{Numeric value. The bird flying speed (\eqn{v}), in
metres/sec.}

\item{wing_span}{Numeric value. The wingspan of the bird (\eqn{W}), in
metres.}

\item{body_lt}{Numeric value. The length of the bird (\eqn{L}), in metres.}
}
\value{
a matrix. The probability of collisions at different flight height bands
}
\description{
Calculates single transit collision risk at grid points (X, Y) inside the
left-half of the rotor circle, for a given flight direction (upwind or
downwind), and assuming no avoidance action. The origin of the (X, Y)
coordinates is the rotor center
}
\details{
Methodology and assumptions underpinning \code{get_pcoll_grid} are
described in section "Extended Approach Taking Account Of Flight Heights" of
\href{https://www.bto.org/sites/default/files/u28/downloads/Projects/Final_Report_SOSS02_Band1ModelGuidance.pdf}{Band (2012)}. Note that collision risk calculations are based on equation (3)
in "Stage C" section, but using (X, Y) coordinates to reference transit
points instead of the equivalent (r, phi) coordinates.
}
\examples{

  rotor_grids <- generate_rotor_grids(yinc = 0.05, xinc = 0.05, chord_prof_5MW)

  get_pcoll_grid(
    rotor_grids = rotor_grids,
    direction = 1,
    rotor_radius = 120,
    blade_width = 5,
    rotor_speed = 15,
    blade_pitch = 15,
    flight_type = "flapping",
    n_blades = 3,
    flight_speed = 13.1,
    wing_span = 1.01,
    body_lt = 0.85)

}
\seealso{
\link{generate_rotor_grids}
}
