% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_theme.r
\docType{class}
\name{theme}
\alias{theme}
\title{Theme objects}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
theme
}
\arguments{
\item{theme}{A string representing a theme in the dataset.}
}
\description{
The \pkg{stoRy} package uses the \code{theme} object to store
information about themes in the package theme dataset.
}
\examples{
########################################################################
# Create a theme object for the theme "utopia" and print the result    #
########################################################################
theme_name <- "utopia"
mytheme <- theme$new(theme_name)
mytheme$print()

########################################################################
# Display the "utopia" theme and its descendent themes in tree format  #
########################################################################
print_tree(mytheme)

########################################################################
# Display the "society" theme hierarchy in tree format                 #
########################################################################
theme_name <- "society"
mytheme <- theme$new(theme_name)
print_tree(mytheme, pruneMethod = "dist", limit = 50)
}
\keyword{datasets}
