\name{stmCorrViz}
\alias{stmCorrViz}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Generate STM Correlation Tree
}
\description{
This function generates an interactive, full-model HTML visualization of topic hierachies for a fitted \href{http://structuraltopicmodel.com/}{STM} model. The visualization highlights the correlations among topics, and can be used to view the model at differing levels of complexity. The function makes use of the \href{http://d3js.org/}{D3.js} visualization library. The visualization needs to be viewed in a compatible web browser.
}
\usage{
stmCorrViz(mod, file_out, documents_raw=NULL, documents_matrix=NULL,
           title="STM Model", clustering_threshold=1.5, 
           labels_number=7, display=TRUE, verbose=FALSE)
}
\arguments{
  \item{mod}{
A fitted \code{STM} object from \pkg{stm}.  
}
  \item{file_out}{
Name of the output file that will be generated by the function. This should end with an HTML extension.}
  \item{documents_raw}{
  The raw documents used to generate the STM model. A character vector where each entry is the full text of a document.
  }
  \item{documents_matrix}{
  Document-term matrix representation of the raw documents, as generated by the \code{\link[stm]{prepDocuments}} function.
  }
  \item{title}{
Root node label. This defaults to "STM Model".
}
  \item{clustering_threshold}{
A parameter specifying the level of aggregation in the hierarchical clustering routine for topics. Lower threshold values produce more binary splits and deeper trees, while higher threshold values produce more aggregation and trees that have significant breadth rather than depth. See below for more details.
}
  \item{labels_number}{
The number of top words used to label each node (topic or topical cluster) in the visualization.
}
\item{display}{
	Boolean. If set to TRUE, the visualization is launched in the system's default web browser upon function execution.
}
\item{verbose}{
	Boolean. If set to TRUE, displays function progress in the console during execution.
}

}
\details{
This function generates a full-model, interactive, general-purpose hierarchical representation of an STM model.
First a hierarchy of topics is created using hierarchical clustering as implemented in \code{hclust}.
Then the hierarchy is written out to a JSON object using \code{\link{stmJSON}}.  Finally \href{http://d3js.org/}{D3.js} is used to create
an interactive visualization.

The visualization is built as a HTML page, and as such requires a web browser for inspection. 
The function does not return and object, but writes HTML output to disk.

The visualization takes the form of an indented tree. The leaves of the tree correspond to topics. 
The leaf nodes are grouped in topic clusters. This allows the model to be visualized at differing levels of aggregation.
The function uses the D3.js library for visualization purpose. 
The visualization is largely built on top of Mike Bostock's \href{http://bl.ocks.org/mbostock/1093025}{Collapsible Indented Tree} block. A nested JSON structure representing the hierarchical model is produced using the \code{\link{stmJSON}} function.
}

\examples{
  \dontrun{
      require(stm)
      data(gadarian)

      # Pre-processing the data
      temp <- textProcessor(documents=gadarian$open.ended.response, 
        metadata=gadarian)
      meta <- temp$meta
      vocab <- temp$vocab
      docs <- temp$documents
      out <- prepDocuments(docs, vocab, meta)
      docs <-out$documents
      vocab<-out$vocab
      meta <-out$meta

      # Fitting the STM model
      set.seed(02138)
      mod.out <- stm(docs, vocab, 20, 
        prevalence=~treatment + s(pid_rep), data=meta)

      # Generating the visualization
      stmCorrViz(mod.out, "corrviz.html", 
           documents_raw=as.character(gadarian$open.ended.response), 
           documents_matrix=docs,
           verbose=TRUE)

    }
}

\references{
Bostock M, Vadim O, Jeffrey H. D3: Data-Driven Documents. Visualization and Computer Graphics, IEEE Transactions on 17.12 (2011): 2301-2309.

Margaret E. Roberts, Brandon M. Stewart and Dustin Tingley (2014). \href{http://structuraltopicmodel.com/}{stm: R Package for Structural Topic Models}.
}

\seealso{
   \code{\link{stmJSON}}
}

