% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teffEst.R
\name{teffEst}
\alias{teffEst}
\title{STFIT Temporal Effect Estimation}
\usage{
teffEst(
  ids,
  doy,
  rmat,
  doyeval = seq(min(doy), max(doy)),
  h.cov = 100,
  h.sigma2 = 300,
  weight.cov = NULL,
  weight.sigma2 = NULL,
  pve = 0.99,
  t.grid = NULL,
  t.grid.num = 50,
  var.est = FALSE
)
}
\arguments{
\item{ids}{ids for 'group', for data with repeated measurement over years, year is ids; 
for pixels belong to certain clusters, cluster is ids.}

\item{doy}{vecotr of DOY (day of the year)}

\item{rmat}{residual matrix with rows corresponding to \code{doy} and columns corresponding to pixel index}

\item{doyeval}{a vector of DOY on which to get the temporal imputation}

\item{h.cov}{bandwidth for temporal covariance estimation; ignored if \code{weight.cov} is supplied}

\item{h.sigma2}{bandwidth for temporal variance estimation}

\item{weight.cov}{weight vector for temporal covariance estimation}

\item{weight.sigma2}{weight vector for temporal variance estimation}

\item{pve}{percentage of variance explained; used for number of eigen values selection. Default is 0.99.}

\item{t.grid}{a vector of grid points on which to calculate the temporal covariance function}

\item{t.grid.num}{number of grid points to use for temporal covariance estimation. Ignored if \code{t.grid} is given.}

\item{var.est}{Whether to estimate the variance of the temporal effect. Default is FALSE.}
}
\value{
List of length 2 with entries:
  \itemize{
    \item teff_array: 3-d array with first dimention 'ids', second dimention 'doy' and third
    dimention pixel index.
    \item teff_var_array: same structure as \code{teff_array} if \code{var.est} is TRUE,
    otherwise NULL.
  }
}
\description{
STFIT Temporal Effect Estimation
}
