% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOrderbook.R
\name{getOrderbook}
\alias{getOrderbook}
\title{Returns details on the current state of the order book}
\usage{
getOrderbook(selling_asset_type, selling_asset_code = NULL,
  selling_asset_issuer = NULL, buying_asset_type, buying_asset_code = NULL,
  buying_asset_issuer = NULL, limit = 10)
}
\arguments{
\item{selling_asset_type}{required, character - Type of the Asset being sold    native}

\item{selling_asset_code}{optional, character - code of the Asset being sold    USD}

\item{selling_asset_issuer}{optional, character - account ID of the issuer of the Asset being sold    GA2HGBJIJKI6O4XEM7CZWY5PS6GKSXL6D34ERAJYQSPYA6X6AI7HYW36}

\item{buying_asset_type}{required, character - type of the Asset being bought    credit_alphanum4}

\item{buying_asset_code}{optional, character - code of the Asset being bought    BTC}

\item{buying_asset_issuer}{optional, character - account ID of the issuer of the Asset being bought}

\item{limit}{optional, numeric - the number of records to return.}
}
\value{
list
}
\description{
Return a summary of assets bought and sold on the ledger.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/orderbook-details.html
}
\examples{
\donttest{getOrderbook(selling_asset_type = "native", buying_asset_type = "credit_alphanum4")}
}
