% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPaymentPaths.R
\name{findPaymentPaths}
\alias{findPaymentPaths}
\title{Find a payment path between a source and a destination.}
\usage{
findPaymentPaths(destination_account, destination_asset_type,
  destination_asset_code, destination_asset_issuer, destination_amount,
  source_account)
}
\arguments{
\item{destination_account}{character - The destination account that any returned path should use.}

\item{destination_asset_type}{character - The type of the destination asset    credit_alphanum4}

\item{destination_asset_code}{character - The code for the destination, if destination_asset_type is not “native”.}

\item{destination_asset_issuer}{character - The issuer for the destination, if destination_asset_type is not “native”.}

\item{destination_amount}{character - The amount, denominated in the destination asset, that any returned path should be able to satisfy.}

\item{source_account}{character - The sender’s account id. Any returned path must use a source that the sender can hold.}
}
\value{
list
}
\description{
Calculate a path for a payment based on the assets the source/target owns.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/path-finding.html
}
