% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect}
\alias{collect}
\title{Runs multiple calls against an endpoint to create a larger data set.}
\usage{
collect(endpoint, n = 11, order = "asc", data.table = TRUE,
  verbose = FALSE)
}
\arguments{
\item{endpoint}{character - one of: payments, operations, effects, trades, transactions, ledgers.}

\item{n}{numeric - the number of *pages* of records to return.
Default is 1, maximum is currently 3600 due to the rate limit for the Horizon API.
Each "page" will return 200 records.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}

\item{verbose}{boolean - if TRUE, the results and number of rows returned will be printed to the console.}
}
\value{
data.table
}
\description{
Get the first n records, most recent n records or records from a range.
}
\note{
https://www.stellar.org/developers/horizon/reference/paging.html
}
\examples{
collect(endpoint = "ledgers", n = 3)
}
