% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{random.yx}
\alias{random.yx}
\title{Generates random bivariate scores}
\usage{
random.yx(n, my, mx, sdy, sdx, cor, dec)
}
\arguments{
\item{n}{sample size}

\item{my}{population mean of y scores}

\item{mx}{population mean of x scores}

\item{sdy}{population standard deviation of y scores}

\item{sdx}{population standard deviation of x scores}

\item{cor}{population correlation between x and y}

\item{dec}{number of decimal points}
}
\value{
Returns n pairs of y and x scores
}
\description{
Generates a random sample of y scores and x scores from a bivariate normal
distributions with specified population means, standard deviations, and
correlation.
}
\examples{
random.yx(10, 50, 20, 4, 2, .5, 1)

# Should return: 
#        y    x
#  1  50.3 21.6
#  2  52.0 21.6
#  3  53.0 22.7
#  4  46.9 21.3
#  5  56.3 23.8
#  6  50.4 20.3
#  7  44.6 19.9
#  8  49.9 18.3
#  9  49.4 18.5
# 10  42.3 20.2
 

}
