% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectSerieOut.R
\name{removeSerieOut}
\alias{removeSerieOut}
\title{Replace outliers for series of observations by NA}
\usage{
removeSerieOut(
  dat = NULL,
  fitSpline = NULL,
  serieOut,
  trait = attr(x = serieOut, which = "trait")
)
}
\arguments{
\item{dat}{A \code{data.frame}.}

\item{fitSpline}{An object of class \code{HTPSpline}, the output of the
\code{\link{fitSpline}} function.}

\item{serieOut}{A data.frame with at least the column plotId with
values corresponding to those in dat/fitSpline.}

\item{trait}{The trait that should be replaced by NA. Can be ignored when
using the output of \code{detectSerieOut} as input.}
}
\value{
Depending on the input either a \code{data.frame} or an object of
class \code{HTPSpline} for which the outliers specified in \code{serieOut}
are replace by NA.
}
\description{
Function for replacing outliers for series of observations in the data by NA.
The input can either be a data.frame, specified in \code{dat}, or the output
of the \code{fitSpline} function, specified in \code{fitSpline}. Exactly one
of these should be provided as input for the function.
}
\examples{
## Run the function to fit P-spline on a subset of genotypes.
subGenoVator <- c("G160", "G151")
fit.spline <- fitSpline(inDat = spatCorrectedVator,
                        trait = "EffpsII_corr",
                        genotypes = subGenoVator,
                        knots = 50)

## Extract the tables of predicted values and P-spline coefficients.
predDat <- fit.spline$predDat
coefDat <- fit.spline$coefDat

## The coefficients are then used to tag suspect time courses
outVator <- detectSerieOut(corrDat = spatCorrectedVator,
                           predDat = predDat,
                           coefDat = coefDat,
                           trait = "EffpsII_corr",
                           genotypes = subGenoVator,
                           thrCor = 0.9,
                           thrPca = 30)

## Replace the outliers by NA in the corrected data.
spatCorrectedVatorOut <- removeSerieOut(dat = spatCorrectedVator,
                                        serieOut = outVator)

}
\seealso{
Other functions for detecting outliers for series of observations: 
\code{\link{detectSerieOut}()},
\code{\link{plot.serieOut}()}
}
\concept{functions for detecting outliers for series of observations}
