/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import java.util.Arrays;
import sample.HapNodes;
import vcf.AL;

public class HapBaumLevel {
    private static final int INITIAL_CAPACITY = 100;
    private static final float MIN_VALUE = 1.4E-43f;
    private final Dag dag;
    private final AL al;
    private int marker = -1;
    private int hap = -1;
    private int size = 0;
    private int capacity = 100;
    private int[] edges = new int[100];
    private float[] fwdValues = new float[100];
    private float[] bwdValues = new float[100];
    private float fwdValueSum = 0.0f;
    private float bwdValueSum = 0.0f;
    private int nAlleles = 0;
    private float[] alProbs = new float[3];

    public HapBaumLevel(Dag dag, AL aL) {
        if (!dag.markers().equals(aL.markers())) {
            throw new IllegalArgumentException("marker inconsistency");
        }
        this.dag = dag;
        this.al = aL;
    }

    public void setForwardValues(HapNodes hapNodes, int n, int n2) {
        this.marker = n;
        this.hap = n2;
        this.nAlleles = this.al.marker(n).nAlleles();
        this.size = 0;
        this.fwdValueSum = 0.0f;
        this.bwdValueSum = 0.0f;
        this.initializeAlProbs();
        this.setStates(hapNodes);
        this.setChildNodes(hapNodes);
    }

    private void initializeAlProbs() {
        if (this.alProbs.length < this.nAlleles) {
            int n = Math.max(this.nAlleles, 3 * this.alProbs.length / 2 + 1);
            this.alProbs = new float[n];
        } else {
            Arrays.fill(this.alProbs, 0, this.nAlleles, 0.0f);
        }
    }

    private void setStates(HapNodes hapNodes) {
        int n;
        float f = 0.0f;
        int n2 = hapNodes.size();
        for (n = 0; n < n2; ++n) {
            int n3 = hapNodes.enumNode(n);
            int n4 = this.dag.nOutEdges(this.marker, n3);
            for (int i = 0; i < n4; ++i) {
                int n5 = this.dag.outEdge(this.marker, n3, i);
                int n6 = this.dag.symbol(this.marker, n5);
                float f2 = this.al.al(this.marker, this.hap, n6);
                if (!(f2 > 0.0f)) continue;
                if (this.size == this.capacity) {
                    this.ensureCapacity(this.size + 1);
                }
                this.edges[this.size] = n5;
                float f3 = this.dag.condEdgeProb(this.marker, n5);
                float f4 = f2 * hapNodes.enumValue(n) * f3;
                if (f4 < 1.4E-43f) {
                    assert ((double)hapNodes.enumValue(n) > 0.0);
                    f4 = 1.4E-43f;
                }
                this.fwdValues[this.size++] = f4;
                f += f4;
            }
        }
        assert ((double)f > 0.0 ^ this.size == 0);
        n = 0;
        while (n < this.size) {
            int n7 = n++;
            this.fwdValues[n7] = this.fwdValues[n7] / f;
        }
        this.fwdValueSum = f;
    }

    public void setChildNodes(HapNodes hapNodes) {
        hapNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edges[i]);
            hapNodes.sumUpdate(n, this.fwdValues[i]);
        }
    }

    public void setBackwardValues(HapNodes hapNodes) {
        int n;
        for (int i = 0; i < this.size; ++i) {
            float f;
            n = this.dag.childNode(this.marker, this.edges[i]);
            this.bwdValues[i] = f = hapNodes.value(n);
            this.bwdValueSum += f;
        }
        hapNodes.clear();
        float f = 0.0f;
        for (n = 0; n < this.size; ++n) {
            int n2 = n;
            this.bwdValues[n2] = this.bwdValues[n2] / this.bwdValueSum;
            int n3 = this.edges[n];
            int n4 = this.symbol(n);
            float f2 = this.dag.condEdgeProb(this.marker, n3);
            float f3 = this.fwdValues[n] * this.bwdValues[n];
            int n5 = n4;
            this.alProbs[n5] = this.alProbs[n5] + f3;
            f += f3;
            float f4 = this.bwdValues[n] * f2 * this.al.al(this.marker, this.hap, n4);
            if (f4 < 1.4E-43f && (double)this.bwdValues[n] > 0.0) {
                f4 = 1.4E-43f;
            }
            int n6 = this.dag.parentNode(this.marker, n3);
            hapNodes.sumUpdate(n6, f4);
        }
        n = 0;
        while (n < this.nAlleles) {
            int n7 = n++;
            this.alProbs[n7] = this.alProbs[n7] / f;
        }
    }

    public Dag dag() {
        return this.dag;
    }

    public AL emissions() {
        return this.al;
    }

    public int marker() {
        return this.marker;
    }

    public int nAlleles() {
        return this.nAlleles;
    }

    public float alProbs(int n) {
        if (n >= this.nAlleles) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return this.alProbs[n];
    }

    public int size() {
        return this.size;
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(this.size));
        }
    }

    public int edge(int n) {
        this.checkIndex(n);
        return this.edges[n];
    }

    public int parentNode(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edges[n]);
    }

    public int childNode(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edges[n]);
    }

    public int symbol(int n) {
        return this.dag.symbol(this.marker, this.edge(n));
    }

    public float forwardValue(int n) {
        this.checkIndex(n);
        return this.fwdValues[n];
    }

    public float backwardValue(int n) {
        this.checkIndex(n);
        return this.bwdValues[n];
    }

    public float forwardValuesSum() {
        return this.fwdValueSum;
    }

    public float backwardValuesSum() {
        return this.bwdValueSum;
    }

    public String toString() {
        String string = " ";
        String string2 = " | ";
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("level=");
        stringBuilder.append(this.marker);
        stringBuilder.append(" size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" forwardValuesSum=");
        stringBuilder.append(this.fwdValueSum);
        stringBuilder.append(" backwardSum=");
        stringBuilder.append(this.bwdValueSum);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("j=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.edge(i));
            stringBuilder.append(string);
            stringBuilder.append(this.forwardValue(i));
            stringBuilder.append(string);
            stringBuilder.append(this.backwardValue(i));
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            this.capacity = this.capacity * 3 / 2 + 1;
            if (this.capacity < n) {
                this.capacity = n;
            }
            this.edges = Arrays.copyOf(this.edges, this.capacity);
            this.fwdValues = Arrays.copyOf(this.fwdValues, this.capacity);
            this.bwdValues = Arrays.copyOf(this.bwdValues, this.capacity);
        }
    }
}

