% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createGData.R
\name{gData}
\alias{gData}
\alias{createGData}
\title{S3 Class gData}
\usage{
createGData(
  gData = NULL,
  geno = NULL,
  map = NULL,
  kin = NULL,
  pheno = NULL,
  covar = NULL
)
}
\arguments{
\item{gData}{An optional gData object to be modified. If \code{NULL}, a new
gData object is created.}

\item{geno}{A matrix or data.frame with genotypes in the rows and markers in
the columns. A matrix from the \code{matrix} in the base package may be
provided as well as as matrix from the Matrix package.\cr
If no row names are provided, they are taken from \code{pheno} (if supplied 
and dimension matches). If no column names are provided, the row names
from \code{map} are used (if supplied and dimension matches).}

\item{map}{A data.frame with columns \code{chr} for chromosome and
\code{pos} for position. Positions can be in base pair (bp) or centimorgan (cM). They
should not be cumulative over the chromosomes. Other columns are ignored.
Marker names should be in the row names. These should match the marker names
in \code{geno} (if supplied).}

\item{kin}{A kinship matrix or list of kinship matrices with genotype in
rows and colums. These matrices can be from the \code{matrix} class, as
defined in the base package, or from the \code{dsyMatrix} class, the class
of symmetric matrices in the Matrix package.\cr
The genotypes should be identical to the genotypes in \code{geno}.\cr
If a list of kinship matrices is provided these are supposed to be
chromosome specific matrices. In that case their names should match
the names of the chromosomes in \code{map}. If no names are
provided, the number of matrices should match the number of chromosomes
in \code{map} in which case default names are provided.}

\item{pheno}{A data.frame or a list of data.frames with phenotypic data,
with genotypes in the first column \code{genotype} and traits in the
following columns. The trait columns should be numerical columns only.
A list of data.frames can be used for replications, i.e. different
trials.}

\item{covar}{A data.frame with extra covariates per genotype. Genotypes
should be in the rows.}
}
\value{
An object of class \code{gData} with the following components:
\item{\code{map}}{a data.frame containing map data. Map is sorted by
chromosome and position.}
\item{\code{markers}}{a matrix containing marker information.}
\item{\code{pheno}}{a list of data.frames containing phenotypic data.}
\item{\code{kinship}}{a kinship matrix.}
\item{\code{covar}}{a data.frame with extra covariates.}
}
\description{
\code{createGData} creates an object of S3 class gData with genotypic and
phenotypic data for usage in further analysis. All input to the function is
optional, however at least one input should be provided. It is possible to
provide an existing \code{gData} object as additional input in which case
data is added to this object. Existing data will be overwritten with a
warning.
}
\examples{
set.seed(1234)
## Create genotypic data.
geno <- matrix(sample(x = c(0, 1, 2), size = 15, replace = TRUE), nrow = 3)
dimnames(geno) <- list(paste0("G", 1:3), paste0("M", 1:5))

## Construct map.
map <- data.frame(chr = c(1, 1, 2, 2, 2), pos = 1:5,
                  row.names = paste0("M", 1:5))

## Compute kinship matrix.
kin <- kinship(X = geno, method = "IBS")

## Create phenotypic data.
pheno <- data.frame(paste0("G", 1:3),
                    matrix(rnorm(n = 12, mean = 50, sd = 5), nrow = 3),
                    stringsAsFactors = FALSE)
dimnames(pheno) = list(paste0("G", 1:3), c("genotype", paste0("T", 1:4)))

## Combine all data in gData object.
gData <- createGData(geno = geno, map = map, kin = kin, pheno = pheno)
summary(gData)

## Construct covariate.
covar <- data.frame(C1 = c("a", "a", "b"), row.names = paste0("G", 1:3))

## Compute alternative kinship matrix.
kin2 <- kinship(X = geno, method = "astle")

## Add covariates to previously created gData object and overwrite
## current kinship matrix by newly computed one.
gData2 <- createGData(gData = gData, kin = kin2, covar = covar)

}
\seealso{
\code{\link{summary.gData}}
}
\author{
Bart-Jan van Rossum
}
