/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import java.util.Arrays;
import sample.DuoNodes;
import vcf.BasicGL;
import vcf.GL;

public class DuoBaumLevel {
    private static final int INITIAL_CAPACITY = 400;
    private static final float MIN_VALUE = 1.4E-43f;
    private final Dag dag;
    private final GL gl;
    private int marker = -1;
    private int sampleA = -1;
    private int sampleB = -1;
    private int size = 0;
    private int capacity = 400;
    private int[] edgesAB1 = new int[400];
    private int[] edgesA2 = new int[400];
    private int[] edgesB2 = new int[400];
    private float[] fwdValues = new float[400];
    private float[] bwdValues = new float[400];
    private float fwdValueSum = 0.0f;
    private float bwdValueSum = 0.0f;
    private int nGenotypes = 0;
    private float[] gtProbsA = new float[3];
    private float[] gtProbsB = new float[3];

    public DuoBaumLevel(Dag dag, GL gL) {
        if (!dag.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("marker inconsistency");
        }
        this.dag = dag;
        this.gl = gL;
    }

    public void setForwardValues(DuoNodes duoNodes, int n, int n2, int n3) {
        this.marker = n;
        this.sampleA = n2;
        this.sampleB = n3;
        this.nGenotypes = this.gl.marker(n).nGenotypes();
        this.size = 0;
        this.fwdValueSum = 0.0f;
        this.bwdValueSum = 0.0f;
        this.initializeGtProbs();
        this.setStates(duoNodes);
        this.setChildNodes(duoNodes);
    }

    private void initializeGtProbs() {
        if (this.gtProbsA.length < this.nGenotypes) {
            int n = Math.max(this.nGenotypes, 3 * this.gtProbsA.length / 2 + 1);
            this.gtProbsA = new float[n];
            this.gtProbsB = new float[n];
        } else {
            for (int i = 0; i < this.nGenotypes; ++i) {
                this.gtProbsA[i] = 0.0f;
                this.gtProbsB[i] = 0.0f;
            }
        }
    }

    private void setStates(DuoNodes duoNodes) {
        int n;
        float f = 0.0f;
        int n2 = duoNodes.size();
        for (n = 0; n < n2; ++n) {
            int n3 = duoNodes.enumNodeAB1(n);
            int n4 = duoNodes.enumNodeA2(n);
            int n5 = duoNodes.enumNodeB2(n);
            float f2 = duoNodes.enumValue(n);
            int n6 = this.dag.nOutEdges(this.marker, n3);
            for (int i = 0; i < n6; ++i) {
                int n7 = this.dag.outEdge(this.marker, n3, i);
                int n8 = this.dag.symbol(this.marker, n7);
                int n9 = this.dag.nOutEdges(this.marker, n4);
                for (int j = 0; j < n9; ++j) {
                    int n10 = this.dag.outEdge(this.marker, n4, j);
                    int n11 = this.dag.symbol(this.marker, n10);
                    float f3 = this.gl.gl(this.marker, this.sampleA, n8, n11);
                    if (!((double)f3 > 0.0)) continue;
                    int n12 = this.dag.nOutEdges(this.marker, n5);
                    for (int k = 0; k < n12; ++k) {
                        float f4;
                        float f5;
                        float f6;
                        float f7;
                        int n13 = this.dag.outEdge(this.marker, n5, k);
                        int n14 = this.dag.symbol(this.marker, n13);
                        float f8 = this.gl.gl(this.marker, this.sampleB, n8, n14);
                        if (!((double)f8 > 0.0)) continue;
                        if (this.size == this.capacity) {
                            this.ensureCapacity(this.size + 1);
                        }
                        if ((f7 = f3 * f8 * f2 * ((f6 = this.dag.condEdgeProb(this.marker, n7)) * (f5 = this.dag.condEdgeProb(this.marker, n10)) * (f4 = this.dag.condEdgeProb(this.marker, n13)))) < 1.4E-43f && (double)f2 > 0.0) {
                            f7 = 1.4E-43f;
                        }
                        this.edgesAB1[this.size] = n7;
                        this.edgesA2[this.size] = n10;
                        this.edgesB2[this.size] = n13;
                        this.fwdValues[this.size++] = f7;
                        f += f7;
                    }
                }
            }
        }
        assert ((double)f > 0.0 ^ this.size == 0);
        n = 0;
        while (n < this.size) {
            int n15 = n++;
            this.fwdValues[n15] = this.fwdValues[n15] / f;
        }
        this.fwdValueSum = f;
    }

    public void setChildNodes(DuoNodes duoNodes) {
        duoNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edgesAB1[i]);
            int n2 = this.dag.childNode(this.marker, this.edgesA2[i]);
            int n3 = this.dag.childNode(this.marker, this.edgesB2[i]);
            duoNodes.sumUpdate(n, n2, n3, this.fwdValues[i]);
        }
    }

    public void setBackwardValues(DuoNodes duoNodes) {
        int n;
        int n2;
        int n3;
        for (int i = 0; i < this.size; ++i) {
            float f;
            n3 = this.dag.childNode(this.marker, this.edgesAB1[i]);
            n2 = this.dag.childNode(this.marker, this.edgesA2[i]);
            n = this.dag.childNode(this.marker, this.edgesB2[i]);
            this.bwdValues[i] = f = duoNodes.value(n3, n2, n);
            this.bwdValueSum += f;
        }
        duoNodes.clear();
        float f = 0.0f;
        for (n3 = 0; n3 < this.size; ++n3) {
            float f2;
            int n4 = n3;
            this.bwdValues[n4] = this.bwdValues[n4] / this.bwdValueSum;
            n2 = this.symbolAB1(n3);
            n = this.symbolA2(n3);
            int n5 = this.symbolB2(n3);
            float f3 = this.dag.condEdgeProb(this.marker, this.edgesAB1[n3]);
            float f4 = this.dag.condEdgeProb(this.marker, this.edgesA2[n3]);
            float f5 = this.dag.condEdgeProb(this.marker, this.edgesB2[n3]);
            float f6 = this.fwdValues[n3] * this.bwdValues[n3];
            int n6 = BasicGL.genotype(n2, n);
            int n7 = BasicGL.genotype(n2, n5);
            int n8 = n6;
            this.gtProbsA[n8] = this.gtProbsA[n8] + f6;
            int n9 = n7;
            this.gtProbsB[n9] = this.gtProbsB[n9] + f6;
            f += f6;
            float f7 = this.gl.gl(this.marker, this.sampleA, n2, n);
            float f8 = this.bwdValues[n3] * (f3 * f4 * f5) * (f7 * (f2 = this.gl.gl(this.marker, this.sampleB, n2, n5)));
            if (f8 < 1.4E-43f && this.bwdValues[n3] > 0.0f) {
                f8 = 1.4E-43f;
            }
            int n10 = this.dag.parentNode(this.marker, this.edgesAB1[n3]);
            int n11 = this.dag.parentNode(this.marker, this.edgesA2[n3]);
            int n12 = this.dag.parentNode(this.marker, this.edgesB2[n3]);
            duoNodes.sumUpdate(n10, n11, n12, f8);
        }
        n3 = 0;
        while (n3 < this.nGenotypes) {
            int n13 = n3;
            this.gtProbsA[n13] = this.gtProbsA[n13] / f;
            int n14 = n3++;
            this.gtProbsB[n14] = this.gtProbsB[n14] / f;
        }
    }

    public Dag dag() {
        return this.dag;
    }

    public GL gl() {
        return this.gl;
    }

    public int marker() {
        return this.marker;
    }

    public int nGenotypes() {
        return this.nGenotypes;
    }

    public float gtProbsA(int n) {
        this.checkGT(n);
        return this.gtProbsA[n];
    }

    public float gtProbsB(int n) {
        this.checkGT(n);
        return this.gtProbsB[n];
    }

    private void checkGT(int n) {
        if (n >= this.nGenotypes) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    public int size() {
        return this.size;
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(this.size));
        }
    }

    public int edgeAB1(int n) {
        this.checkIndex(n);
        return this.edgesAB1[n];
    }

    public int edgeA2(int n) {
        this.checkIndex(n);
        return this.edgesA2[n];
    }

    public int edgeB2(int n) {
        this.checkIndex(n);
        return this.edgesB2[n];
    }

    public int parentNodeAB1(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesAB1[n]);
    }

    public int parentNodeA2(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesA2[n]);
    }

    public int parentNodeB2(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edgesB2[n]);
    }

    public int childNodeAB1(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesAB1[n]);
    }

    public int childNodeA2(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesA2[n]);
    }

    public int childNodeB2(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edgesB2[n]);
    }

    public int symbolAB1(int n) {
        return this.dag.symbol(this.marker, this.edgeAB1(n));
    }

    public int symbolA2(int n) {
        return this.dag.symbol(this.marker, this.edgeA2(n));
    }

    public int symbolB2(int n) {
        return this.dag.symbol(this.marker, this.edgeB2(n));
    }

    public float forwardValue(int n) {
        this.checkIndex(n);
        return this.fwdValues[n];
    }

    public float backwardValue(int n) {
        this.checkIndex(n);
        return this.bwdValues[n];
    }

    public float forwardValuesSum() {
        return this.fwdValueSum;
    }

    public float backwardValuesSum() {
        return this.bwdValueSum;
    }

    public String toString() {
        String string = " ";
        String string2 = " | ";
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("level=");
        stringBuilder.append(this.marker);
        stringBuilder.append(" size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" forwardValuesSum=");
        stringBuilder.append(this.fwdValueSum);
        stringBuilder.append(" backwardSum=");
        stringBuilder.append(this.bwdValueSum);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("j=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.edgeAB1(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edgeA2(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edgeB2(i));
            stringBuilder.append(string);
            stringBuilder.append(this.forwardValue(i));
            stringBuilder.append(string);
            stringBuilder.append(this.backwardValue(i));
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            this.capacity = this.capacity * 3 / 2 + 1;
            if (this.capacity < n) {
                this.capacity = n;
            }
            this.edgesAB1 = Arrays.copyOf(this.edgesAB1, this.capacity);
            this.edgesA2 = Arrays.copyOf(this.edgesA2, this.capacity);
            this.edgesB2 = Arrays.copyOf(this.edgesB2, this.capacity);
            this.fwdValues = Arrays.copyOf(this.fwdValues, this.capacity);
            this.bwdValues = Arrays.copyOf(this.bwdValues, this.capacity);
        }
    }
}

