% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrend.R
\name{detrend}
\alias{detrend}
\title{Detrend a Digital Elevation Model}
\usage{
detrend(x, parallel = 1)
}
\arguments{
\item{x}{A two-dimensional \code{stars} object representing the DEM}

\item{parallel}{Number of parallel processes. With \code{parallel=1} uses ordinary, non-parallel processing.}
}
\value{
A two-dimensional \code{stars} object, with two attributes:\itemize{
\item{\code{resid} - the detrended result, i.e., "residual"}
\item{\code{trend} - the estimated "trend" which was subtracted from the actual elevation to obtain \code{resid}}
}
}
\description{
Detrends a Digital Elevation Model (DEM) raster, by subtracting a trend surface. The trend is computed using \code{mgcv::gam} or \code{mgcv::bam} (when \code{parallel>1}) with formula \code{z ~ s(x, y)}.
}
\examples{
# Small example
data(dem)
dem1 = detrend(dem)
dem1 = st_redimension(dem1)
dem1 = st_set_dimensions(dem1, 3, values = c("resid", "trend"))
plot(round(dem1), text_values = TRUE, col = terrain.colors(11))
\donttest{
# Larger example 1
data(carmel)
carmel1 = detrend(carmel, parallel = 2)
carmel1 = st_redimension(carmel1)
carmel1 = st_set_dimensions(carmel1, 3, values = c("resid", "trend"))
plot(carmel1, col = terrain.colors(11))

# Larger example 2
data(golan)
golan1 = detrend(golan, parallel = 2)
golan1 = st_redimension(golan1)
golan1 = st_set_dimensions(golan1, 3, values = c("resid", "trend"))
plot(golan1, col = terrain.colors(11))
}
}
