% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_to_stars.R
\name{matrix_to_stars}
\alias{matrix_to_stars}
\title{Convert \code{matrix} to \code{stars}}
\usage{
matrix_to_stars(m, res = 1)
}
\arguments{
\item{m}{A \code{matrix}}

\item{res}{The cell size, default is \code{1}}
}
\value{
A \code{stars} raster
}
\description{
Converts \code{matrix} to a single-band \code{stars} raster, conserving the matrix orientation where rows become the y-axis and columns become the y-axis. The bottom-left corner of the axis is set to \code{(0,0)} coordinate, so that x and y coordinates are positive across the raster extent.
}
\examples{
data(volcano)
r = matrix_to_stars(volcano, res = 10)
plot(r)

}
