% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMXStanModel.R
\name{copy}
\alias{copy}
\title{Replication of an existing \code{PMXStanModel} object}
\usage{
copy(model, newpath = NULL, compile = FALSE)
}
\arguments{
\item{model}{a \code{PMXStanModel} object.}

\item{newpath}{a string for user to specify the path to store the new model object. 
If not provided, the new path will be named by adding a suffix "_copy" to the path 
of the model being copied.}

\item{compile}{a logical variable indicating whether to compile the Stan code in the new \code{PMXStanModel}
object during the initialization process (\code{TRUE}) or not (\code{FALSE}, as default).}
}
\value{
A replicated version of the specified existing \code{PMXStanModel} object.
}
\description{
Makes a copy of an existing \code{PMXStanModel} object into a new path.
}
\details{
The \code{copy()} function for a \code{PMXStanModel} object aims to provide a convenient way for the
following scenarios:

- Fitting the same model to different datasets. With each copy of the model, a new input dataset  
  can be used for generating samples, and each will result in a \code{PMXStanFit} objects. These results
  can then be compared and summarized.

- An exploratory, stage-wise modeling exercise, commonly used when current knowledge is not sufficient
  to choose among options through the model building process. One can start from a copy of the same
  "parent" version of the model, make specific changes one at a time, and later make a choice based on
  certain criteria to compare different fittings.
}
\examples{
\dontrun{
m1 <- PMXStanModel(path = tempfile("pk_m1"))
m2 <- copy(m1, newpath = "pk_m2", compile = TRUE)
}
}
\author{
Yuan Xiong and Wenping Wang
}
\seealso{
\code{\link{PMXStanModel}} for the creation of a new \code{PMXStanModel} object.
}

