% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8-conversion-functions.R
\name{as.character.parentslist}
\alias{as.character.parentslist}
\alias{print.parentslist}
\title{Print a parentslist object}
\usage{
\method{as.character}{parentslist}(x, only_parents = FALSE, ...)

\method{print}{parentslist}(x, ...)
}
\arguments{
\item{x}{an object of class \code{parentslist}.}

\item{only_parents}{logical, if the basic DAG encoding is to be returned.}

\item{...}{additional arguments for compatibility.}
}
\value{
\code{as.character.parentslist} returns a string
encoding the associated directed graph and eventually
the context specific independences.
The encoding is similar to the one returned by
\code{modelstring} in package \pkg{bnlearn}
and package \pkg{deal}.
In particular, parents of a variable can be enclosed in:
\itemize{
\item \code{( )} if a partial (conditional) independence is present.
\item \code{{ }} if a context specific independence is present.
\item \code{< >} if no context specific and partial (conditional)
independences are present, but at least a
local independence is detected.
}

If a parent is not enclosed in parenthesis the dependence is full.

If \code{only_parents = TRUE}, the simple DAG encoding as in \pkg{bnlearn}
is returned.
}
\description{
Nice print of a parentslist object
}
\examples{
model <- stages_hclust(full(Titanic), k = 2)
pl <- as_parentslist(model)
pl
as.character(pl)
as.character(pl, only_parents = TRUE)
}
