% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-model-selection.R
\name{bhcr.sevt}
\alias{bhcr.sevt}
\title{Backward Random Hill-Climbing}
\usage{
bhcr.sevt(
  object,
  score = function(x) return(-BIC(x)),
  max_iter = 100,
  trace = 0
)
}
\arguments{
\item{object}{a staged event tree model}

\item{score}{the score function to be maximized}

\item{max_iter}{the maximum number of iteration}

\item{trace}{if >0 increasingly amount of info
is printed (via \code{message})}
}
\value{
The final staged event tree object
}
\description{
Randomly try to join stages
}
\details{
At each iteration a variable and
two of its stages are randomly selected.
If joining the stages increase the score, the model is
updated. The procedure is repeated until the
number of iterations reach \code{max_iter}.
}
\examples{
DD <- generate_xor_dataset(n = 4, N = 100)
model <- bhcr.sevt(full(DD), trace = 2)
summary(model)
}
