% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_ge_weight.R
\docType{methods}
\name{model,report_ge_weight-method}
\alias{model,report_ge_weight-method}
\alias{model.report_ge_weight}
\title{model method for report_ge_weight' 
this method uses samples collected over the season to model the variation in weight of
glass eel or yellow eels.}
\usage{
\S4method{model}{report_ge_weight}(object, model.type = "seasonal",
  silent = FALSE)
}
\arguments{
\item{object}{An object of class \link{report_ge_weight-class}}

\item{model.type}{default "seasonal", "seasonal1","seasonal2","manual".}

\item{silent}{Default FALSE, if TRUE the program should no display messages}
}
\description{
model method for report_ge_weight' 
this method uses samples collected over the season to model the variation in weight of
glass eel or yellow eels.
}
\details{
Depending on model.type several models are produced
\itemize{
\item{model.type="seasonal".}{ The simplest model uses a seasonal variation, it is
				fitted with a sine wave curve allowing a cyclic variation 
				w ~ a*cos(2*pi*(d'-T)/365)+b with a period T. The modified day d' used is this model is set
				at 1 the 1st of august doy = d' + d0; d0 = 212, doy=julian days}
\item{model.type="seasonal1".}{ A time component is introduced in the model, which allows
			for a long term variation along with the seasonal variation. This long term variation is
			is fitted with a gam, the time variable is set at zero at the beginning of the first day of observed values.
			The seasonal variation is modeled on the same modified julian time as model.type="seasonal"
			but here we use a cyclic cubic spline cc, which allows to return at the value of d0=0 at d=365.
			This model was considered as the best to model size variations by Diaz & Briand in prep. but using a large set of values
			over years.}
\item{model.type="seasonal2".}{The seasonal trend in the previous model is now modelled with a sine
			curve similar to the sine curve used in seasonal.  The formula for this is \eqn{sin(\omega vt) + cos(\omega vt)}{sin(omega vt) + cos(omega vt)}, 
		where vt is the time index variable \eqn{\omega}{omega} is a constant that describes how the index variable relates to the full period
			(here, \eqn{2\pi/365=0.0172}{2pi/365=0.0172}). The model is written as following \eqn{w~cos(0.0172*doy)+sin(0.0172*doy)+s(time).}}
\item{model.type="manual".}{ The dataset don (the raw data), coe (the coefficients already present in the
			database, and newcoe the dataset to make the predictions from, are written to the environment envir_stacomi. 
			please see example for further description on how to fit your own model, build the table of coefficients,
			and write it to the database.}	
}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}

