% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\name{predictors}
\alias{predictors}
\title{Common argument}
\arguments{
\item{predictors}{List of predictors.\cr
According to the paradigm of this implementation, the trend, the seasonal components,
the flexible predictors and the seasonal predictors are all presented in the same
form (as predictors) and must be described in this list.\cr
Every predictor is a list of the following structures:\cr
\itemize{
\item \strong{data} -- vector of length \emph{\strong{L}} (length of input data,
  see above). For trend or for a seasonal component it is a vector of ones.
  For a flexible or a seasonal predictor it is a vector of the predictor's data.
\item \strong{times} -- vector of length \emph{\strong{L}} of times of observations.
\item \strong{seasons} -- vector of length \emph{\strong{L}}. It is a vector of ones
  for a trend or a flexible predictor. It is vector assigning seasons to every
  observation (for a seasonal component or a seasonal predictor).
  Seasons can be fractional for observations in between seasons.
\item \strong{timeKnots} -- vector of times (time knots) where knots are positioned
  (for a seasonal component or a seasonal predictor a few knots have the same time;
  every knot is represented by time and season). Usually this vector coincides with
  \strong{times} vector described above, or \strong{timeKnots} is a subset of
  \strong{times} vector.
\item \strong{seasonalStructure} -- describes seasonal topology (which can have complex
  structure) and seasonal knots.The seasonal topology is described by a list of
  segments and seasonal knots, which are positioned inside the segments, on borders of
  the segments or, when they are on on borders, they can connect two or more segments.\cr
\strong{seasonalStructure} is a list of two elements:\cr
\itemize{
\item \strong{segments} -- a list of vectors representing segments.
Each vector must contain two ordered real values which represent left and right borders
  of a segment. Segments should not intersect (inside same predictor).
\item \strong{sKnots} -- a list of real values (vectors of length one) or vectors of
  lengths two or greater (seasonal knots) defining seasons of the knots (every knot
  is represented by time and season). All real values must belong (be inside or on
  border of) segments listed in \strong{segments}. If a few values represent a single
  seasonal knot then all these values must be on borders of some segments (or a single
  segment). In this case they represent a seasonal knot which connects a few segments
  (or both sides of one segment).
}
\item \strong{lambdas} -- a vector with three values representing lambda (smoothing)
  parameters (time-time, season-season, time-season flexibility parameters) for this
  predictor.
}}
}
\description{
Common argument
}
\keyword{internal}

