% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonLifeRisk-base.R
\name{summary.nonLifeRisk}
\alias{summary.nonLifeRisk}
\title{Summarizing a nonLifeRisk}
\usage{
\method{summary}{nonLifeRisk}(object, ...)
}
\arguments{
\item{object}{S3 object of class lifeRisk.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
an S3 object, instance of class \code{c("summaryDefault", "table")}.
}
\description{
summary method for the S3 class nonLifeRisk.
}
\examples{
# Creating a new nonLifeRisk.
nonLife1 <- nonLifeRisk(type     = "simulations",
                        param    = list(simulations = stats::rnorm(100)),
                        currency =  "CHF")
# summarizing the nonLifeRisk.
summary(nonLife1)
# Creating a new nonLifeRisk.
nonLife2 <- nonLifeRisk(type     = "log-normal",
                        param    = list(mu = 1, sigma = 2),
                        currency =  "CHF")
# summarizing the nonLifeRisk.
summary(nonLife2)
# Creating a new nonLifeRisk.
nonLife3 <- nonLifeRisk(type = "cdf",
                        param = list(cdf = data.frame(x = c(0,1,2,3),
                                                      cdf = c(0.3,0.7,0.9, 1))),
                        currency = "CHF")
# summarizing the nonLifeRisk.
summary(nonLife3)

}
\seealso{
\code{\link[base]{summary}}, \code{\link{nonLifeRisk}}.
}
