% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.counts.R
\name{sim.counts}
\alias{sim.counts}
\title{RNA-seq Count Data Simulation from Negative-Binomial Distribution}
\usage{
sim.counts(nGenes = 10000, pi0 = 0.8, m, mu, disp, logfc, up = 0.5,
  replace = TRUE)
}
\arguments{
\item{nGenes}{total number of genes, the default value is \code{10000}.}

\item{pi0}{proportion of non-differentially expressed genes, 
the default value is \code{0.8}.}

\item{m}{sample size per treatment group.}

\item{mu}{a vector (or scalar) of mean counts in control group 
from which to simulate.}

\item{disp}{a vector (or scalar) of dispersion parameter 
from which to simulate.}

\item{logfc}{a vector (or scalar, or a function that takes an integer n 
          and generates a vector of length n)
of log fold change for differentially expressed (DE) genes.}

\item{up}{proportion of up-regulated genes among all DE genes, 
the default value is \code{0.5}.}

\item{replace}{sample with or without replacement from given parameters. 
See Details for more information.}
}
\value{
\item{counts}{RNA-seq count data matrix.}

\item{group}{treatment group vector.}

\item{lambda0}{mean counts in control group for each gene.}

\item{phi0}{dispersion parameter for each gene.}

\item{de}{differentially expressed genes indicator: 
                  \code{0} for non-differentially expressed genes, 
                  \code{1} for up-regulated genes, 
                  \code{-1} for down-regulated genes.}

\item{delta}{log fold change for each gene between 
                     treatment group and control group.}
}
\description{
This function simulates count data from Negative-Binomial distribution
for two-sample RNA-seq experiments with given mean, dispersion 
and log fold change. 
A count data matrix is generated.
}
\details{
If the total number of genes \code{nGenes} is larger 
         than length of \code{mu} or \code{disp}, 
         \code{replace} always equals \code{TRUE}.
}
\examples{
m <- 3                    ## sample size per treatment group
mu <- 10                  ## mean counts in control group for all genes 
disp <- 0.1               ## dispersion for all genes
logfc <- log(2)           ## log fold change for DE genes

sim <- sim.counts(m = m, mu = mu, disp = disp, logfc = logfc)
sim$counts                ## count data matrix


## varying fold change
logfc1 <- function(x){rnorm(x, log(2), 0.5*log(2))}
sim1 <- sim.counts(m = m, mu = mu, disp = disp, logfc = logfc1)

}
\author{
Ran Bi \email{biran@iastate.edu}, 
        Peng Liu \email{pliu@iastate.edu}
}

