% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-cdf.R
\name{ssd_plot_cdf}
\alias{ssd_plot_cdf}
\alias{ssd_plot_cdf.fitdists}
\alias{ssd_plot_cdf.list}
\title{Plot Cumulative Distribution Function (CDF)}
\usage{
ssd_plot_cdf(x, ...)

\method{ssd_plot_cdf}{fitdists}(x, average = FALSE, delta = 7, ...)

\method{ssd_plot_cdf}{list}(x, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Additional arguments passed to \code{\link[=ssd_plot]{ssd_plot()}}.}

\item{average}{A flag specifying whether to model average the estimates.}

\item{delta}{A non-negative number specifying the maximum absolute Akaike Information-theoretic Criterion difference cutoff. Distributions with an absolute difference from the best model greater than the cutoff are excluded.}
}
\description{
Generic function to plots the cumulative distribution function (CDF).
}
\section{Methods (by class)}{
\itemize{
\item \code{fitdists}: Plot CDF for fitdists object

\item \code{list}: Plot CDF for named list of distributional parameter values
}}

\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
ssd_plot_cdf(fits)

ssd_plot_cdf(list(
  llogis = c(locationlog = 2, scalelog = 1),
  lnorm = c(meanlog = 2, sdlog = 2))
)
}
\seealso{
\code{\link[=ssd_plot]{ssd_plot()}}

\code{\link[=estimates.fitdists]{estimates.fitdists()}} and \code{\link[=ssd_match_moments]{ssd_match_moments()}}
}
