% Generated by roxygen2 (4.0.1): do not edit by hand
\name{srd}
\alias{srd}
\title{Draws scaled rectangle diagrams to represent categorical data.}
\usage{
srd(data = stop("'data' must be specified"), weight = NA,
  labelcell = "frequency", new = TRUE, criterion = "logl",
  colour = "earthy", labelrectangle = "inside", y = NA, w = NA,
  cells = FALSE, motion = "none", thin = NA)
}
\arguments{
\item{data}{A binary data matrix of ones and zeroes (or TRUE and FALSE) with k columns, with 1 or TRUE
representing presence of an attribute that represents a rectangle.}

\item{weight}{A frequency count vector attaches a frequency weight to each row of \code{d}.}

\item{labelcell}{Attaches labels to cells.
One of "none", "frequency", "area", "error", or "residual". Use "frequency" for cell frequencies (default), "area" for areas, "error" for percentage error, "residual" for Pearson residuals}

\item{new}{TRUE or FALSE. Fits a new configuration, new=FALSE  assumes an existing configuration already exists}

\item{criterion}{Criterion to determine fitting optimisation.  One of "lsqs", "labs", "logl", or "chi2".
Use "lsqs" for least squares (default), "labs" for least absolute difference, "logl" for minus log-likelihood,
"chi2" for chi-square}

\item{colour}{Determines colour of configuration. One of "earthy", "bright", or  "mono". Use "earthy" for muted
colours, "bright" for rainbow colours (default), "mono" is monochrome (shades of grey).
If \code{cells=TRUE},  "earthy" and "bright" are interpreted as shades of yellow and blue respectively.}

\item{labelrectangle}{To attach labels to each of the k rectangles.
One of "none", "inside", or "arrow". Use "none" for no labels,  "inside" (default) for inside rectangle,
"arrow" is an arrow pointer from outside of the unit square.}

\item{y}{A vector of data (with same number of rows as \code{d}) for the third axis in a 3D projection .
Default NA is equivalent to a vector of zeroes.
Projected values are  mean values of \code{y}, or \eqn{\sum y / \sum w} if \code{w} is specified. Projected values are of
each rectangle, or if \code{cells=TRUE} of each cell (see \code{cells} parameter)}

\item{w}{A numeric vector associated with  \code{y}.
Statistics of \code{y} for cells/rectangles (see cells argument) represented by \eqn{\sum y / \sum w}.
Default NA gives 3D projection as mean values of \code{y} (equivalent to \code{w=1}).
\code{w} can be used, for example, to obtain 3D projection axis as a "incidence rate" if \code{y} is
a binary indicator of an outcome and \code{w} is person-time.}

\item{cells}{TRUE or FALSE. True for a diagram shaded by mean of y in each cell of
intersecting rectangles and 3D projection showing each cell. Default (FALSE) is  transparent represention of each of k rectangles,
and 3D projection the mean of \code{y}
of each rectangle.}

\item{motion}{Determines whether and how configuration is put into 3D mode.
One of values "none", "frames", "movie".  "none"  for a flat single image, "frames" for broken series
of rotated images, "movie"  for an animated rotating movie.}

\item{thin}{Parameter to attempt to avoid thin and elongated rectangles. The
\code{criterion} is penalised by multiplying by \eqn{x^thin} where is \eqn{x}
 is maximal thinness (length/breadth) of the \eqn{q} rectangles.
 Recommended value \eqn{<=1}. Default NA is no penalising, equivalent to \eqn{thin=0}.}
}
\value{
Error message, or indication of successful completion.
}
\description{
Draws scaled rectangle diagrams to represent categorical data.
}
\details{
A function to visualise  k attributes as a Venn-like  diagram
with areas scaled, as best as possible, to be proportional to  frequency.
It is a representation is of a \eqn{2^q} contingency table.
Up to six attributes (rectangles) can be displayed.
Fitting is done by optimising the congruence between cell area and cell frequency by the
chosen criterion. A flat diagram can be thrown into an animated 3D projection, showing
mean/rate values of the associated \code{y} with \code{motion} equal to "frames" or "movie".
}
\examples{
library(datasets)
data(Titanic)
x <- data.frame(Titanic)
x$women<-  ifelse(x$Sex=="Female",1,0)
x$child <- ifelse(x$Age=="Child",1,0)
x$first <- ifelse(x$Class=="1st",1,0)
x$survived <- ifelse(x$Survived=="yes",1,0)
d <- x[c("women","child","first")]
srd(data=d,y=x$survived,weight=x$Freq,motion="frames")


library(survival)
data(pbc)
## create srd and show projection axis as incidence rate (by specifying w as time)
pbc$male <- ifelse(pbc$sex=="m",1,0)
d  <- with(pbc,cbind(ascites,hepato,spiders,male))
pbc$event <- ifelse(pbc$status==2,1,0)
srd(d, y=pbc$event, w=pbc$time, colour="earthy",
   labelrectangle="arrow",cells=FALSE,motion="frames", criterion="chi2", thin=0.5)
}
\author{
Roger Marshall, <rj.marshall@auckland.ac.nz>, The University of Auckland, New Zealand
}
\references{
Marshall, RJ.  Displaying  categorical data relationships by scaled rectangle diagrams. Statistics in Medicine 20, 1077-1088, 2001.
Marshall, RJ. Scaled rectangle diagrams can be used to visualise clinical and epidemiological data.
Journal of Clinical Epidemiology 58, 974-981, 2005.
Marshall, RJ. Determining and visualising at-risk groups in case-control data.
Journal of Epidemiology and Biostatistics  6,  343-348, 2001
}

