% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-kmeans.R
\name{plot.kma_qts}
\alias{plot.kma_qts}
\alias{autoplot.kma_qts}
\title{QTS K-Means Visualization}
\usage{
\method{plot}{kma_qts}(x, ...)

\method{autoplot}{kma_qts}(x, ...)
}
\arguments{
\item{x}{An object of class \code{kmeans_qts} as produced by the \code{\link[=kmeans_qts]{kmeans_qts()}}
function.}

\item{...}{Further arguments to be passed to other methods.}
}
\value{
The \code{\link[=plot.kma_qts]{plot.kma_qts()}} method does not return anything while the
\code{\link[=autoplot.kma_qts]{autoplot.kma_qts()}} method returns a \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
QTS K-Means Visualization
}
\examples{
res_kma <- kmeans_qts(vespa64$igp, k = 2, nstart = 1)
plot(res_kma)
ggplot2::autoplot(res_kma)
}
