% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tournament_.R
\name{get_tournament_matches}
\alias{get_tournament_matches}
\title{Get a tournament's matches from SquashInfo}
\usage{
get_tournament_matches(tournament = NULL, year = NULL, world_tour = NULL)
}
\arguments{
\item{tournament}{character string of name of the tournament. Partial tournament names are matched via regular expressions.}

\item{year}{integer indicating year of competition. Must be 2020, 2021, or NULL if querying results for both years.}

\item{world_tour}{logical indicating whether to only return PSA World Tour tournaments.}
}
\value{
Tibble containing the tournament name, competition category, tournament date, round, player 1, player 2, the match winner, games won (by player 1), games lost (by player 1), the match time, player 1's seed, player 2's seed, player 1's nationality, player 2's nationality.
}
\description{
Given a tournament name or a year, \code{get_tournament_matches()} returns match data for PSA World Tour tournaments and other events.
}
\note{
This function only returns match data from tournaments in 2020 and 2021, as any other data are not available to non-premium members on SquashInfo. Additionally, events that do not use a single elimination format are not included in the results (e.g. Karakal Premier League).
}
\examples{
## Return match data for 2020's Tournament of Champions.
\donttest{get_tournament_matches("tournament of champions", year = 2020, world_tour = TRUE)}

## Return match data for all PSA World Tour tournaments in 2020
\donttest{get_tournament_matches(year = 2020, world_tour = TRUE)}



}
\references{
\url{http://www.squashinfo.com/results}
}
