% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv.R
\name{sv}
\alias{sv}
\title{Semi-variogram computation}
\usage{
sv(data, xcoordcol, ycoordcol, residcol, bins = 15, cutoff = NULL, ...)
}
\arguments{
\item{data}{A data frame or tibble that contains variables for the
x coordinates, y coordinates, and residuals.}

\item{xcoordcol}{is the name of the column in the data frame with
x coordinates or longitudinal coordinates}

\item{ycoordcol}{is the name of the column in the data frame with
y coordinates or latitudinal coordinates}

\item{residcol}{is the name of the column in the data frame with residuals.}

\item{bins}{Number of equally spaced semivariogram bins. The default is 15.}

\item{cutoff}{The maximum spatial distance to be considered. The default is
half of the maximum observed distance in the data frame.}

\item{...}{Additional arguments to be used by \code{stats::dist()} for
spatial distance calculations.}
}
\value{
A data frame with the average distance in each bin (dist), the
semivariance (gamma), and the number of unique pairs in each bin (np)
}
\description{
Compute the empirical semivariogram for a data set with specified
x and y spatial coordinates and residuals.
}
\examples{
data(exampledataset) ## load a toy data set
slmobj <- slmfit(formula = counts ~ pred1 + pred2, data = exampledataset,
xcoordcol = 'xcoords', ycoordcol = 'ycoords', areacol = 'areavar')
sampleddataset <- na.omit(exampledataset)
svexample <- data.frame(
  xcoords = sampleddataset$xcoords,
  ycoords = sampleddataset$ycoords,
  resids = residuals(slmobj)
)
svdata <- sv(svexample, "xcoords", "ycoords", "resids")
}
