% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changevar.size.R
\name{changevar.size}
\alias{changevar.size}
\title{Covariance or Correlation Matrix Estimate of Change in Class Resource Sizes
between Two Surveys}
\usage{
changevar.size(catvar.levels, catvar1, catvar2, wgt, x, y, revisitwgt,
  size1, size2, stratum.ind, stratum.level, cluster.ind, cluster, wgt1, x1,
  y1, pcfactor.ind, pcfsize, N.cluster, stage1size, support, vartype,
  warn.ind, warn.df, warn.vec)
}
\arguments{
\item{catvar.levels}{Vector of the set of categorical response values.}

\item{catvar1}{Vector of the response value for each site for survey one.}

\item{catvar2}{Vector of the response value for each site for survey two.}

\item{wgt}{Vector of the final adjusted weight (inverse of the sample
inclusion probability) for each site, which is either the weight for a
single-stage sample or the stage two weight for a two-stage sample.}

\item{x}{Vector of x-coordinate for location for each site, which is either
the x- coordinate for a single-stage sample or the stage two x-coordinate
for a two-stage sample.}

\item{y}{Vector of y-coordinate for location for each site, which is either
the y- coordinate for a single-stage sample or the stage two y-coordinate
for a two-stage sample.}

\item{revisitwgt}{Logical value that indicates whether each repeat visit
site has the same survey design weight in the two surveys, where TRUE = the
weight for each repeat visit site is the same and FALSE = the weight for
each repeat visit site is not the same.  When this argument is FALSE, all
of the repeat visit sites are assigned equal weights when calculating the
covariance component of the change estimate standard error.}

\item{size1}{The set of category size estimates for survey one.}

\item{size2}{The set of category size estimates for survey two.}

\item{stratum.ind}{Logical value that indicates whether the sample is
stratified, where TRUE = a stratified sample and FALSE = not a stratified
sample.}

\item{stratum.level}{The stratum level.}

\item{cluster.ind}{Logical value that indicates whether the sample is a two-
stage sample, where TRUE = a two-stage sample and FALSE = not a two-stage
sample.}

\item{cluster}{Vector of the stage one sampling unit (primary sampling unit
or cluster) code for each site.}

\item{wgt1}{Vector of the final adjusted stage one weight for each site.}

\item{x1}{Vector of the stage one x-coordinate for location for each site.}

\item{y1}{Vector of the stage one y-coordinate for location for each site.}

\item{pcfactor.ind}{Logical value that indicates whether the population
correction factor is used during variance estimation, where TRUE = use the
population correction factor and FALSE = do not use the factor.  To employ
the correction factor for a single-stage sample, values must be supplied
for arguments pcfsize and support.  To employ the correction factor for a
two-stage sample, values must be supplied for arguments N.cluster,
stage1size, and support.}

\item{pcfsize}{Size of the resource, which is required for calculation of
finite and continuous population correction factors for a single-stage
sample. For a stratified sample this argument must be a vector containing a
value for each stratum and must have the names attribute set to identify
the stratum codes.}

\item{N.cluster}{The number of stage one sampling units in the resource,
which is required for calculation of finite and continuous population
correction factors for a two-stage sample.  For a stratified sample this
variable must be a vector containing a value for each stratum and must have
the names attribute set to identify the stratum codes.}

\item{stage1size}{Size of the stage one sampling units of a two-stage
sample, which is required for calculation of finite and continuous
population correction factors for a two-stage sample and must have the
names attribute set to identify the stage one sampling unit codes.  For a
stratified sample, the names attribute must be set to identify both stratum
codes and stage one sampling unit codes using a convention where the two
codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1".}

\item{support}{Vector of the support value for each site - the value one
(1) for a site from a finite resource or the measure of the sampling unit
associated with a site from a continuous resource, which is required for
calculation of finite and continuous population correction factors.}

\item{vartype}{The choice of variance estimator, where "Local" = local mean
estimator and "SRS" = SRS estimator.}

\item{warn.ind}{Logical value that indicates whether warning messages were
generated, where TRUE = warning messages were generated and FALSE = warning
messages were not generated.}

\item{warn.df}{Data frame for storing warning messages.}

\item{warn.vec}{Vector that contains names of the population type, the
subpopulation, and an indicator.}
}
\value{
An object in list format composed of a vector named rslt, which
  contains the covariance or correlation estimates, a logical variable named
  warn,ind, which is the indicator for warning messges, and a data frame
  named warn.df, which contains warning messages.
}
\description{
This function uses the repeat visit sites for two probability surveys to
calculate either covariance or correlation estimates of estimated change in
resource size in each of a set of categories.  Covariance estimates are
calculated when the resivit sites have the same survey design weight in both
surveys.  Correlation estimates are calculated when the revisit sites do not
have the same weight in both surveys, in which case the sites are assigned
equal weights.  The revisitwgt argument controls whether covariance or
correlation estimates are calculated.  Either the simple random sampling
(SRS) variance/covariance estimator or the local mean variance/covariance
estimator is calculated, which is subject to user control.  The simple random
sampling variance/covariance estimator uses the independent random sample
approximation to calculate joint inclusion probabilities.  The function can
accomodate single-stage and two-stage samples.  Finite population and
continuous population correction factors can be utilized in variance
estimation.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{\link{localmean.weight}}}{calculate the weighting matrix for
      the local mean variance estimator}
    \item{\code{\link{localmean.cov}}}{calculate the variance/covariance
      matrix using the local mean estimator}
  }
}

\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
