% Copyright 2002 by Roger S. Bivand
\name{eigenw}
\alias{eigenw}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Spatial weights matrix eigenvalues}
\description{
  The function returns a numeric vector of eigenvalues of the weights matrix
generated from the spatial weights object \code{listw}. The eigenvalues are 
used to speed the computation of the Jacobian in spatial SAR model estimation:

\deqn{\log(\det[I - \rho W]) = \log\prod_{i=1}^{n}(1 - \rho \lambda_i)}

where $W$ is the n by n spatial weights matrix, and $\lambda_i$ are the
eigenvalues of $W$.
}
\usage{
eigenw(listw, quiet=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{listw}{a \code{listw} object created for example by \code{nb2listw}}
  \item{quiet}{set to FALSE for short summary}
}

\value{
  a numeric vector of eigenvalues of the weights matrix generated from the
spatial weights object \code{listw}.
}
\references{Cliff, A. D., Ord, J. K. 1981 Spatial processes, Pion, p. 155;
Ord, J. K. 1975 Estimation methods for models of spatial interaction, Journal
of the American Statistical Association, 70, 120-126.}
\author{Roger Bivand \email{Roger.Bivand@nhh.no}}

\seealso{\code{\link{eigen}}, %\code{\link{log.spwdet}}
}

\examples{
require(spweights)
require(sptests)
data(oldcol)
W.eig <- eigenw(nb2listw(COL.nb, style="W"))
1/range(W.eig)
S.eig <- eigenw(nb2listw(COL.nb, style="S"))
1/range(S.eig)
B.eig <- eigenw(nb2listw(COL.nb, style="B"))
1/range(B.eig)
}
\keyword{spatial}
