% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plots.R
\name{plot.damcmc_res}
\alias{plot.damcmc_res}
\title{Plot results from a DAMCMC fit}
\usage{
\method{plot}{damcmc_res}(x, burnin = floor(length(fit$allgens)/10), ...)
}
\arguments{
\item{x}{Object of class \code{damcmc_res}.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{...}{Additional arguments for the S3 method.}
}
\description{
This function uses the posterior realizations
from a \code{\link{est_mix_damcmc}} call, to produce a plethora
of plots about the fitted Poisson point process with mixture intensity surface.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#plot.damcmc_res}
}
\examples{
\donttest{
fit <- est_mix_damcmc(pp = spatstat::redwood, m = 10)
plot(fit)
#Tornadoes
Tornfit=est_mix_damcmc(Tornadoes2011MO, m=5, L = 20000)
MAPsurf=GetMAPEst(Tornfit)
ret=PlotUSAStates(states=c('Iowa','Arkansas', 'Missouri','Illinois','Indiana',
 'Kentucky','Tennessee', 'Kansas','Nebraska','Texas','Oklahoma','Mississippi',
 'Alabama','Louisiana'),showcentroids=FALSE, shownames=TRUE, plotlevels = FALSE,
 main="Tornadoes about MO, 2011", pp=Tornadoes2011MO, surf=MAPsurf,
 boundarycolor="white", namescolor="white")
print(ret)
plot(Tornfit)
# get the intensity of posterior means
post_mean = GetPMEst(Tornfit)
# plot the estimated intensity surface
plot(post_mean)
#check labels
check_labels(Tornfit)
# If present then fix label switching, start with approx=TRUE
post_fixed = FixLS_da(Tornfit, plot_result = TRUE)
plot_chains(post_fixed)
plot_chains(post_fixed,separate = FALSE)}

}
\seealso{
\code{\link{est_mix_damcmc}},
\code{\link{PlotUSAStates}},
\code{\link{GetPMEst}},
\code{\link{check_labels}},
\code{\link{FixLS_da}},
\code{\link{plot_chains}}
}
\author{
Jiaxun Chen, Sakis Micheas, Yuchen Wang
}
