% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix.R
\name{normmix}
\alias{normmix}
\alias{print.normmix}
\alias{print.intensity_surface}
\alias{summary.normmix}
\alias{summary.intensity_surface}
\title{Create a 2d mixture with normal components}
\usage{
normmix(ps, mus, sigmas, lambda = NULL, win = NULL, estimated = FALSE)

\method{print}{normmix}(x, ...)

\method{print}{intensity_surface}(x, ...)

\method{summary}{normmix}(object, ...)

\method{summary}{intensity_surface}(object, ...)
}
\arguments{
\item{ps}{Vector of component probabilities.}

\item{mus}{A list where every element is a vector of length 2, defining the
center of each component.}

\item{sigmas}{A list where every element is a 2 by 2 covariance matrix,
defining the covariance for each component.}

\item{lambda}{Optional parameter denoting the average number of points over the
window. If set along with the \code{win} parameter,
the returned object will be an intensity surface.}

\item{win}{Optional parameter for the window of
observation, an object of type \code{\link[spatstat]{owin}}.
Must be set together with \code{lambda} in
order to create an intensity surface.}

\item{estimated}{Logical variable to indicate
that this is an estimated mixture not the true mixture surface.
By default it is set to FALSE, but when using the function to
define an mixture based on estimates of the parameters it
should be set to TRUE.}

\item{x}{An object of class \code{normmix} or \code{intensity_surface}.}

\item{...}{Additional arguments for the S3 method.}

\item{object}{An object of class \code{normmix} or \code{intensity_surface}.}
}
\value{
An object of class "normmix" containing the following components:
 \item{m}{Number of components.}
 \item{ps}{Vector of component probabilities.}
 \item{mus}{List of mean vectors of the components.}
 \item{sigmas}{List of covariance matrices of the components.}
 \item{lambda}{Returned only if lambda is provided when calling
 \code{normmix}.}
 \item{window}{Returned only \code{win} is provided when calling
 \code{normmix}. This is an object of class \code{\link[spatstat]{owin}}.}
 \item{estimated}{Whether the normal mixture is estimated.}
}
\description{
Constructor function for the \code{normmix} class. Creates a mixture in
two dimensions with bivariate normal components. If the parameters
lambda and window are set, this function will create an intensity surface
object of class \code{intensity_surface}.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#normmix}

The \code{print} function can be used on a \code{normmix}
or \code{intensity_surface} object in order to display basic information.

The \code{summary} function can be used on a \code{normmix}
or \code{intensity_surface} object in order to display additional information.
}
\examples{
\donttest{
mix1 <- normmix(ps = c(.3, .7), mus = list(c(0.2, 0.2), c(.8, .8)),
 sigmas = list(.01*diag(2), .01*diag(2)))
mix1
summary(mix1)
intsurf1 <- normmix(ps = c(.3, .7), mus = list(c(0.2, 0.2), c(.8, .8)),
 sigmas = list(.01*diag(2), .01*diag(2)), lambda = 100, win = spatstat::square(1))
intsurf1
summary(intsurf1)}

}
\seealso{
\code{\link{rnormmix}} for
generating a mixture with random parameters.
}
\author{
Yuchen Wang, Sakis Micheas
}
