% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postgen_ops.R
\name{GetBDCompfit}
\alias{GetBDCompfit}
\title{Retrieve parts of a BDMCMC fit}
\usage{
GetBDCompfit(BDfit, num_comp, burnin = floor(BDfit$L/10))
}
\arguments{
\item{BDfit}{Object of class \code{damcmc_res}.}

\item{num_comp}{Number of components requested. Only
the posterior realizations that have this many components will be returned. The function
fails if the BDMCMC chain never visited this number of components.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}
}
\value{
A list containing the following:
 \item{BDgens}{Realizations corresponging to this many mixture components. This is a \code{damcmc_res} object (same as the result of a \code{\link{est_mix_damcmc}} call). All realizations for the requested number of components are returned, that is, burnin is not applied to this object.}
 \item{BDsurf}{For the requested \code{num_comp}, this is the Poisson intensity surface based on the corresponding posterior means (label switching might be present).}
 \item{BDnormmix}{For the requested \code{num_comp}, this is a \code{\link{normmix}} object containing the corresponding ps, mus and sigmas (label switching might be present).}
}
\description{
The function can be used to obtain the realizations and
the corresponding surface of posterior means, for a specific
number of components. Use \code{\link{GetPMEst}} if you want just the surface.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#GetBDCompfit}
}
\examples{
\donttest{
fit <- est_mix_bdmcmc(pp = spatstat::redwood, m = 7)
GetBDTable(fit)
#retrieve all BDMCMC realizations corresponding to a mixture with 5 components
BDfit5comp=GetBDCompfit(fit,5)
plot(BDfit5comp$BDsurf,main="Mixture intensity surface with 5 components")
#plot with the correct window
plot(BDfit5comp$BDnormmix,xlim =BDfit5comp$BDsurf$window$xrange,ylim =
 BDfit5comp$BDsurf$window$yrange )
plot(BDfit5comp$BDgens)}

}
\seealso{
\code{\link{est_mix_bdmcmc}},
\code{\link{GetBDTable}},
\code{\link{plot.damcmc_res}},
\code{\link{plot.normmix}}
}
\author{
Sakis Micheas
}
