% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_time_id.R
\name{transform_time_id}
\alias{transform_time_id}
\title{Transforming a series of time or datetime to time indexes}
\usage{
transform_time_id(obsTime, timeUnit, timeStep)
}
\arguments{
\item{obsTime}{Date/Datetime/Numeric. A vector of observed time of
hot spots.
If \code{timeUnit} is "n", \code{obsTime}
needs to be a numeric vector,
otherwise, it needs to be in
date or datetime format.}

\item{timeUnit}{Character. The unit of time, one of "s" (seconds),
"m"(minutes),
"h"(hours), "d"(days) and "n"(numeric).}

\item{timeStep}{Numeric (>0). Number of units of \code{timeUnit} in a time step.}
}
\value{
Integer. A vector of time indexes.
}
\description{
This function transforms a series of time or datetime to
time indexes.
}
\details{
The earliest time is assigned with a time index \code{1}.
The difference between any other time to the earliest
time is transformed using the \code{timeUnit} and divided
by the \code{timeStep}. These differences are floored to integer and
used as the time indexes.
}
\examples{

# Define obsTime
obsTime <- as.Date(c("2020-01-01",
                     "2020-01-02",
                     "2020-01-04"))

# Transform it to time index under different settings
transform_time_id(obsTime, "h", 1)
transform_time_id(obsTime, "m", 60)
transform_time_id(obsTime, "s", 3600)

# Define numeric obsTime
obsTime <- c(1,
             1.5,
             4.5,
             6)

# Transform it to time index under different settings
transform_time_id(obsTime, "n", 1)
transform_time_id(obsTime, "n", 1.5)


}
