.fA.multi <-
function(Xa, 
                      X, 
                      sigma){
  
  if(missing(Xa)) stop("class A is missing from set")
  if(missing(X)) stop("X input is missing")
  
  m <- nrow(Xa) # total number of training patterns from selected category
  p <- ncol(Xa) # number of input factors
  
  kernl <- (1 / ((det((2*pi)*sigma))^0.5))

  if(is.nan(kernl)){ # nan is returned when kernl -> 0, may be due to small sample size
    kernl <- 0
  }
  
  f <- prod(kernl,
            1/m,
            sum(mapply(FUN = .patterns.multi,
                       Xa = split(Xa, seq(1, nrow(Xa), 1)),
                       MoreArgs = list(X = X,
                                       sigma_inverse = MASS::ginv(sigma)),
                       SIMPLIFY = TRUE)))
  
  if(is.nan(f)){ # asymptotically approaches zero then set to zero
    f <- 0
  }
  
  return(f)
}
.patterns.multi <-
function(Xa, 
                            X, 
                            sigma_inverse){
  
  return(exp(-0.5*(Xa-X)%*%sigma_inverse%*%t(Xa-X))) # mahalanobis + gaussian kernel
}
.pnn.create <-
function(){ # create empty list for pnn
  
  nn <- list(model = "Probabilistic Neural Network", 
             set = NULL)
  
  return(nn)
}
.pnn.guess.probabilities <-
function(nn, 
                                     X){
  
  results <- vector()
  
  for(category in nn$categories){
    Xa <- nn$set[nn$set[,nn$category.column] == category,]
    Xa <- as.matrix(Xa[,-nn$category.column])
    
    if(length(Xa)==0){ #handle zero example case
      results <- c(results, 0)
    }else{
      results <- c(results, .fA.multi(Xa, 
                                      X,
                                      sigma = nn$sigma))
    }
  }
  
  probs <- results / sum(results) #standard output layer
  
  names(probs) <- nn$categories #probabilities of each category
  
  return(probs)
}
.Random.seed <-
c(403L, 14L, 139304918L, 223890513L, -888445181L, -1218253166L, 
1356983332L, -1596845337L, 1055131453L, 1423022004L, 1183833114L, 
-1796372635L, 490019327L, 225932422L, 1434015760L, -651212109L, 
949193041L, 1923025152L, 1863142366L, -1682630615L, 1528860635L, 
1349078250L, -285590900L, -948468273L, 443455877L, -946191812L, 
1162753810L, -724780019L, 1098413895L, 969504046L, -1945672568L, 
607359371L, 1747569001L, -1528011976L, -1654321690L, 2110298497L, 
1784638739L, 718318274L, 1773368692L, -2073279113L, -724685203L, 
-711352060L, 964547626L, -1974343275L, 1653685807L, -1870128330L, 
-1433746592L, 749382051L, -718726463L, 1463046832L, -2057777714L, 
-585555655L, 1682824523L, -1491626246L, -578398212L, 1804892223L, 
-887127787L, -204617172L, -437012734L, -1882278947L, -773030185L, 
-947623490L, 1198459896L, 40198107L, -755920327L, -1147530360L, 
-1970760906L, 1895625073L, -2013590621L, 1543863026L, -1666508220L, 
-1861909241L, 1657928925L, 42645972L, -224125702L, -814259131L, 
1298584735L, -2002012634L, -856083792L, 2074771283L, -49051023L, 
-1602521184L, -1480827074L, -113170871L, 1411924731L, -941915446L, 
1067017260L, 1635261487L, -1120439067L, -130630244L, -1216135182L, 
-2097358227L, -1743315033L, -1937481266L, -2000910552L, 1395445035L, 
1093844809L, 96642136L, -1659444986L, 1576410337L, 1988828275L, 
1016580322L, 181964884L, 634123607L, -109550259L, 920574180L, 
-1638685494L, 964708661L, -1125408881L, 1034140822L, 459732032L, 
-959085309L, 584567073L, -552205808L, -1278342674L, -948544103L, 
-1351423445L, -1740293350L, 404103644L, -53905441L, -1842630731L, 
-1275471540L, -715419742L, 1645651709L, -10426377L, 1913995550L, 
107711448L, 497175867L, -1678865703L, 1030202984L, 2039347094L, 
840254225L, -2145694525L, 785491154L, 198218084L, -918829913L, 
-1208579587L, -1658133516L, 1116814554L, -1956139483L, -1458085057L, 
386543814L, 182390096L, -462834317L, 895541137L, -1004424768L, 
405746590L, 1824730473L, -661981797L, 1177311402L, 1522403020L, 
-1495570545L, -514956347L, 775145340L, 1592948690L, -149448883L, 
1910195719L, -594061842L, 2087739592L, 1632874443L, 1345571369L, 
1942222968L, 1181906342L, -893026367L, 172418131L, 879512322L, 
-31830476L, -799093833L, -165454931L, 1357402308L, -1221335830L, 
-881431723L, 920886511L, -1975733514L, 973930016L, -1762769949L, 
-1357821823L, -1609509136L, 542979470L, -2069988615L, -1857079157L, 
-571457350L, -1379920964L, -306050817L, -2022007723L, 1472161644L, 
1236867010L, 2060361757L, 344711319L, 1443208702L, 2125131192L, 
-852418149L, -2125289479L, -657215672L, 553319030L, 420164529L, 
2013507043L, -408096078L, -426766588L, -1032801209L, -1314077923L, 
1041930644L, -1046520518L, 532595077L, 1064145503L, 1720300774L, 
286721904L, 592906387L, 1359807793L, 1096651744L, -2555778L, 
-1133061367L, -1302905541L, 1472680202L, 1476133100L, -1304285841L, 
-1333235035L, 1764379740L, -749351886L, -1691235539L, -973876761L, 
-1541116658L, -1237957912L, 1052314859L, -653179511L, 1780127000L, 
2096961606L, 805191841L, -601241805L, 1758593452L, -1928796868L, 
-1786363022L, 674936112L, 115253028L, 1165800760L, 701495002L, 
-155625584L, 1685938940L, 1126153108L, 1591346242L, -1127895808L, 
679489596L, 1929993552L, 981857442L, -439579832L, 1010695948L, 
247258844L, 2104936274L, -734923136L, -1163693996L, 22729704L, 
1600359162L, 1449655632L, 687015724L, 569690996L, 1705091986L, 
-2016216480L, -936202356L, -664934560L, 1505242082L, 1094364072L, 
-1611338548L, -55944708L, 264871858L, -2062848528L, 1978199492L, 
699318616L, -1421658758L, 635751856L, 1921229756L, 1832335444L, 
1491201986L, 1366198304L, -1731747652L, -1404749232L, -886704158L, 
-340046232L, -1741656500L, 1149966588L, 2040365042L, 1695651072L, 
-2138731660L, -1202829304L, -686159430L, 734735824L, -805329940L, 
1265425300L, -695604270L, 929189728L, 12761420L, -1313681120L, 
-69169278L, 2086727400L, -1456281364L, -1181909444L, -551562382L, 
-1575422352L, -2134602716L, 240353080L, 1291722906L, -1655966000L, 
-2092985156L, 834828948L, 800017026L, 1731924160L, -1948449476L, 
-1526966128L, -1013678558L, 1474959880L, -1722764020L, 898073244L, 
1430083090L, 1510580608L, 797254164L, -467812824L, -1659707078L, 
497703888L, -700354964L, 598346548L, -2011598190L, 1371731296L, 
-966593204L, -1401891872L, 763908002L, -602681432L, -2066509940L, 
-591516996L, 1334430578L, -2035466000L, 1044380740L, -182641320L, 
-1290252230L, -923880592L, -1197059012L, -2119398636L, -1410458174L, 
-570471200L, 1796151164L, 1464612560L, 511990434L, 1727231016L, 
-1951956724L, 1327954876L, -1663208142L, 1820469184L, 1058580020L, 
783309768L, -644705094L, 1821534096L, -1504679444L, -1701219244L, 
-461325678L, -3138784L, 249528780L, -1570116640L, -1816799550L, 
-1801570776L, 1775455916L, -1889421636L, -1939365390L, -224429776L, 
838830244L, 1173695160L, -1768116390L, 1220296080L, 1470664060L, 
212971796L, -1641603774L, -1464065280L, 315976636L, 320562000L, 
1666913570L, 2096523592L, 950357004L, -1556149156L, -2019117870L, 
-399698944L, 200845140L, 1922025960L, -1639834630L, -1603466544L, 
1290183980L, 1920924916L, 1010574226L, 227937376L, 1718229260L, 
-2122487072L, 1032688994L, -2124458328L, 255864396L, 338015100L, 
362413874L, -1744231824L, -2002202300L, 935602136L, -793054086L, 
-1355392464L, -1935593796L, 1633075028L, 1605701186L, 21446560L, 
670907580L, 1274032592L, -568471198L, 2110957544L, 1135016908L, 
902385404L, -497433614L, 190674048L, -638549772L, 1633820808L, 
-955133638L, -1728220336L, 11534444L, -370156396L, 1537500498L, 
-1751960864L, 592915660L, 2084789408L, -1241686654L, 449170664L, 
2065083628L, -213735364L, 1035390066L, 392182896L, -1941048796L, 
1304843832L, -2104094182L, -1263561520L, -1364040132L, -930357100L, 
653143170L, -510719040L, 1226633532L, -1455575408L, 111084578L, 
-1822494712L, -89099124L, 1076528156L, -693309294L, -1166957440L, 
1019501588L, 2123994920L, -1935030214L, -398886704L, -348030868L, 
673337012L, -885560302L, 1913279456L, -746609716L, -636640800L, 
-1007851486L, -453024472L, 1254469900L, -1011572164L, -895321870L, 
-1749226498L, -2146052116L, 1648931645L, 1856192263L, -2131142928L, 
1581889166L, -828542789L, -813869923L, -1000421302L, 1364900456L, 
-477440431L, -2040681149L, -764011452L, 779497202L, -1474455865L, 
-710263663L, -733646314L, 1232412788L, -1725365499L, -800437937L, 
1007606600L, 339311334L, -1625740269L, 1473573749L, -205225134L, 
1461588896L, -2091944311L, -1011088709L, 2036431116L, -1013009254L, 
-1172870641L, 1909759577L, 2073244398L, -176809604L, -1008268819L, 
-2096449897L, -270028448L, 1769530686L, 502388235L, 667390605L, 
-890417222L, 599776760L, -48432735L, 562306899L, 758124148L, 
-1230180350L, 1692560023L, -44501919L, 535802022L, 1440374948L, 
-651945643L, 886360575L, 1145983128L, -714097226L, 494458435L, 
147676037L, 7536674L, 1151365904L, 1014300345L, 1303778155L, 
-653309348L, -1752529014L, 751187839L, 1158163145L, 1052894046L, 
-1173727220L, 1347250141L, -559467801L, 1055861520L, 963633710L, 
-110135077L, -303684163L, 946664234L, 889314248L, -1752033039L, 
275699299L, 1673323108L, -1498930798L, 978374247L, 135581233L, 
1683477366L, 817711252L, -93595995L, 407057327L, -941629336L, 
-2056903610L, 1968837107L, 1851829589L, 1910044466L, 24206080L, 
234102761L, 1010475611L, 485268652L, -1456250182L, -1408210833L, 
-2037078535L, 1425801358L, -1908946596L, -1436769843L, -625867465L, 
-2039760960L, -1635159906L, 925111659L, -2122191635L, 1946774874L, 
-481444328L, 569621377L, -312819405L, -1734414508L, 2032617826L, 
-1496342025L, 2142728769L, 1687832262L, 433522692L, 1494042549L, 
919959711L, -1052891912L, 70044886L, 716549475L, 396290341L, 
1146793666L, -2086945872L, 104531929L, -864620213L, -685041732L, 
-1661431830L, 708245535L, -800579927L, -657063362L, -902705364L, 
71481725L, -1980553273L, -580473168L, 1694285006L, 1213425147L, 
516439645L, -331003510L, 1081872808L, 1436610321L, -1927688701L, 
-197711612L, 482458930L, -677205113L, 1791572433L, -1177963690L, 
-857867980L, 171100229L, -1407528817L, -1463632376L, 608117286L, 
339665619L, -1514523595L, -1885475950L, 1666308960L, -1435654455L, 
1245321723L, -1998354996L, -1397750694L, -1369556657L, -1346394087L, 
-477925842L, 878924860L, -715906643L, -1879428521L, 71076768L, 
118239486L, 1497314251L, -923671091L, 706218234L, 1701867711L
)
