% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov.spmodel}
\alias{vcov.spmodel}
\alias{vcov.splm}
\alias{vcov.spautor}
\title{Calculate variance-covariance matrix for a fitted model object}
\usage{
\method{vcov}{splm}(object, ...)

\method{vcov}{spautor}(object, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The variance-covariance matrix of coefficients obtained via \code{coef()}.
Currently, only the variance-covariance matrix of the fixed effects is supported.
}
\description{
Calculate variance-covariance matrix for a fitted model object.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
vcov(spmod)
}
