% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_contrast_query.R
\name{spm12_contrast_query}
\alias{spm12_contrast_query}
\alias{spm12_contrast_query_list}
\title{Build contrasts query for SPM12 results}
\usage{
spm12_contrast_query(
  weights = Inf,
  name = "",
  threshold_type = c("FWE", "none", "FDR"),
  threshold = 0.05,
  number_extent_voxels = 0,
  mask_type = c("None", "Contrast", "Image"),
  mask_image = NULL,
  mask_contrast = NULL,
  mask_threshold = 0.05,
  mask_inclusive = TRUE
)

spm12_contrast_query_list(cons)
}
\arguments{
\item{weights}{Weights of the contrast, 
must be the same length as the number of regressors}

\item{name}{Name of the contrast}

\item{threshold_type}{type of thresholding done, if any}

\item{threshold}{Threshold value}

\item{number_extent_voxels}{Number of voxel extent to call
an area a cluster}

\item{mask_type}{type of mask, if any}

\item{mask_image}{If \code{mask_type = "Image"}, then the 
filename of the mask}

\item{mask_contrast}{Vector of weights for the contrast that
will be used as the mask if \code{mask_type = "Contrast"}}

\item{mask_threshold}{if \code{mask_type = "Contrast"},
the threshold for the mask}

\item{mask_inclusive}{Is the mask inclusive?  If \code{FALSE},
then values in the mask which are zero will be included in the
output}

\item{cons}{List of contrasts}
}
\value{
A list of objects, each with a 
\code{titlestr} (title string), contrast, threshold description,
threshold value, extent of voxels, and a mask (if appropriate)
}
\description{
Build contrasts query for SPM12 results
}
\examples{
res = spm12_contrast_query(name = "condition1", weights = 1)
print(res)
contrasts = list(
list(name = "All Contrasts",
       weights = Inf
       ),
list(name = "RightHand",
weights = 2) 
)
res = spm12_contrast_query_list(contrasts)
print(res)
}
