% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/okcv.R
\name{okcv}
\alias{okcv}
\title{Cross validation, n-fold for ordinary kriging (OK)}
\usage{
okcv(longlat, trainy, cv.fold = 10, nmax = 12, transformation = "none",
  delta = 1, vgm.args = ("Sph"), anis = c(0, 1), alpha = 0, block = 0,
  predacc = "VEcv", ...)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of validation
samples.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in longlat.}

\item{cv.fold}{integer; number of folds in the cross-validation. if > 1,
then apply n-fold cross validation; the default is 10, i.e., 10-fold cross
validation that is recommended.}

\item{nmax}{for local kriging: the number of nearest observations that
should be used for a kriging prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12
observations are used.}

\item{transformation}{transform the response variable to normalise the data;
can be "sqrt" for square root, "arcsine" for arcsine, "log" or "none"
for non transformation. By default, "none" is used.}

\item{delta}{numeric; to avoid log(0) in the log transformation.}

\item{vgm.args}{arguments for vgm, e.g. variogram model of response
variable and anisotropy parameters. see notes vgm in gstat for details.
By default, "Sph" is used.}

\item{anis}{anisotropy parameters: see notes vgm in gstat for details.}

\item{alpha}{direction in plane (x,y). see variogram in gstat for details.}

\item{block}{block size. see krige in gstat for details.}

\item{predacc}{can be either "VEcv" for vecv or "ALL" for all measures
in function pred.acc.}

\item{...}{other arguments passed on to gstat.}
}
\value{
A list with the following components:
 me, rme, mae, rmae, mse, rmse, rrmse and vecv; or vecv only
}
\description{
This function is a cross validation function for ordinary
kriging.
}
\note{
This function is largely based on rfcv in randomForest and
some functions in library(gstat).  When 'A zero or negative range was fitted
to variogram' occurs, to allow gstat running, the range was set to be positive by
using min(vgm1$dist). In this case, caution should be taken in applying this
method. If it still occur for okpred function, different method should be
used.
}
\examples{
\dontrun{
library(sp)
data(swmud)
data(petrel)

okcv1 <- okcv(swmud[, c(1,2)], swmud[, 3], nmax = 7, transformation =
"arcsine", vgm.args = ("Sph"), predacc = "VEcv")
okcv1

n <- 20 # number of iterations,60 to 100 is recommended.
VEcv <- NULL
for (i in 1:n) {
okcv1 <- okcv(petrel[, c(1,2)], petrel[, 5], nmax = 12,
transformation = "arcsine", predacc = "VEcv")
VEcv [i] <- okcv1
}
plot(VEcv ~ c(1:n), xlab = "Iteration for OK", ylab = "VEcv (\%)")
points(cumsum(VEcv) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(VEcv), col = 'blue', lwd = 2)

n <- 20 # number of iterations, 60 to 100 is recommended.
measures <- NULL
for (i in 1:n) {
okcv1 <- okcv(petrel[, c(1,2)], petrel[, 3], nmax = 12, transformation =
"arcsine", predacc = "ALL")
measures <- rbind(measures, okcv1$vecv)
}
plot(measures ~ c(1:n), xlab = "Iteration for OK", ylab = "VEcv (\%)")
points(cumsum(measures) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(measures), col = 'blue', lwd = 2)
}

}
\references{
Li, J., 2013. Predictive Modelling Using Random Forest and Its
Hybrid Methods with Geostatistical Techniques in Marine Environmental
Geosciences, In: Christen, P., Kennedy, P., Liu, L., Ong, K.-L., Stranieri,
A., Zhao, Y. (Eds.), The proceedings of the Eleventh Australasian Data
Mining Conference (AusDM 2013), Canberra, Australia, 13-15 November 2013.
Conferences in Research and Practice in Information Technology, Vol. 146.

A. Liaw and M. Wiener (2002). Classification and Regression by
randomForest. R News 2(3), 18-22.

Pebesma, E.J., 2004. Multivariable geostatistics in S: the gstat
package. Computers & Geosciences, 30: 683-691.
}
\author{
Jin Li
}
