% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concat.split.R
\name{concat.split.list}
\alias{concat.split.list}
\alias{cSplit_l}
\title{Split Concatenated Cells into a List Format}
\usage{
cSplit_l(data, split.col, sep = ",", drop = FALSE, fixed = FALSE)
}
\arguments{
\item{data}{The source \code{data.frame} or \code{data.table}.}

\item{split.col}{The variable that needs to be split (either name or index
position).}

\item{sep}{The character separating each value. Can also be a regular expression.}

\item{drop}{Logical. Should the original variable be dropped? Defaults to \code{FALSE}.}

\item{fixed}{Used for \code{\link[base:strsplit]{base::strsplit()}} for allowing regular expressions to
be used.}
}
\value{
A \code{data.frame} or \code{data.table} with the concatenated column split and
added as a \code{list}.
}
\description{
Takes a column in a \code{data.frame} or \code{data.table} with multiple values, splits
the values into a \code{list}, and returns a new \code{data.frame} or \code{data.table}.
}
\examples{

temp <- head(concat.test)
str(cSplit_l(temp, "Likes"))
cSplit_l(temp, 4, ";")

## The old function name still works
str(concat.split.list(temp, "Likes"))
concat.split.list(temp, 4, ";")
concat.split.list(temp, 4, ";", drop = TRUE)

}
\seealso{
\code{\link[=cSplit]{cSplit()}}, \code{\link[=cSplit_e]{cSplit_e()}}
}
\author{
Ananda Mahto
}
