% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splithalf.R
\name{splithalf}
\alias{splithalf}
\title{Internal consistency of task measures via a permutation split-half reliability approach}
\usage{
splithalf(data, outcome = "RT", score = "difference",
  conditionlist = FALSE, halftype = "random", permutations = 5000,
  var.RT = "latency", var.condition = FALSE,
  var.participant = "subject", var.trialnum = "trialnum",
  var.compare = "congruency", compare1 = "Congruent",
  compare2 = "Incongruent", average = "mean")
}
\arguments{
\item{data}{specifies the raw dataset to be processed}

\item{outcome}{indicates the type of data to be processed, e.g. response time or accuracy rates}

\item{score}{indicates how the outcome score is calculated, e.g. most commonly the difference score between two trial types}

\item{conditionlist}{sets conditions/blocks to be processed}

\item{halftype}{specifies the split method; "oddeven", "halfs", or "random"}

\item{permutations}{specifies the number of random splits to run - 5000 is good}

\item{var.RT}{specifies the RT variable name in data}

\item{var.condition}{specifies the condition variable name in data - if not specified then splithalf will treat all trials as one condition}

\item{var.participant}{specifies the subject variable name in data}

\item{var.trialnum}{specifies the trial number variable}

\item{var.compare}{specified the variable that is used to calculate difference scores (e.g. including congruent and incongruent trials)}

\item{compare1}{specifies the first trial type to be compared (e.g. congruent trials)}

\item{compare2}{specifies the first trial type to be compared (e.g. incongruent trials)}

\item{average}{use mean or median to calculate average scores?}
}
\value{
Returns a data frame containing permutation based split-half reliability estimates

splithalf is the raw estimate of the bias index

spearmanbrown is the spearman-brown corrected estimate of the bias index

Warning: If there are missing data (e.g one condition data missing for one participant) output will include details of the missing data and return a dataframe containing the NA data. Warnings will be displayed in the console.
}
\description{
This function calculates split half reliability estimates via a permutation approach for a wide range of tasks
The (unofficial) version name is "This function gives me the power to fight like a crow"
}
\examples{
## see online documentation for examples
}
