% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_basis}
\alias{proto_basis}
\alias{proto_basis1d}
\title{Tour proto for a 2D and 1D basis axes respectively}
\usage{
proto_basis(
  position = c("left", "center", "right", "bottomleft", "topright", "full", "off"),
  manip_col = "blue",
  line_size = 0.6,
  text_size = 4
)

proto_basis1d(
  position = c("bottom1d", "floor1d", "top1d", "full", "off"),
  manip_col = "blue",
  segment_size = 2,
  text_size = 4,
  text_offset = -1.15
)
}
\arguments{
\item{position}{The position, to place the basis axes relative to the
data. \code{proto_basis} expects one of c("left", "center", "right", "bottomleft", "topright",
"off"), defaults to "left". \code{proto_basis1d} expects one of
c("bottom1d", "floor1d", "top1d", "off"). Defaults to "bottom1d".}

\item{manip_col}{The color to highlight the manipulation variable with. Not
applied if the tour isn't a manual tour. Defaults to "blue".}

\item{line_size}{(2D bases only) the thickness of the lines used to make the
axes and unit circle. Defaults to .6.}

\item{text_size}{Size of the text label of the variables. Defaults to 4.}

\item{segment_size}{(1D bases only) the width thickness of the rectangle bar
showing variable magnitude on the axes. Defaults to 2.}

\item{text_offset}{The horizontal offset of the text labels relative to the
variable contributions in the basis between (-1, 1). Defaults to -1.15.}
}
\description{
Adds basis axes to the animation, the direction and magnitude of
contributions of the variables to the projection space inscribed in a unit
circle for 2D or rectangle of unit width for 1D.
}
\examples{
library(spinifex)
dat  <- scale_sd(penguins_na.rm[, 1:4])
clas <- penguins_na.rm$species
bas  <- basis_pca(dat)
mv   <- manip_var_of(bas)

## 2D case:
mt_path <- manual_tour(bas, manip_var = mv)
ggt <- ggtour(mt_path, dat, angle = .3) +
  proto_point() +
  proto_basis()
\donttest{
animate_plotly(ggt)
}

## Customize basis
ggt2 <- ggtour(mt_path, dat) +
  proto_basis(position = "right", manip_col = "green",
              line_size = .8, text_size = 8)
\donttest{
animate_plotly(ggt2)
}

## 1D case:
bas1d     <- basis_pca(dat, d = 1)
mv        <- manip_var_of(bas1d, 3)
mt_path1d <- manual_tour(bas1d, manip_var = mv)

ggt1d <- ggtour(mt_path1d, dat, angle = .3) +
  proto_density() +
  proto_basis1d()
\donttest{
animate_plotly(ggt1d)
}

## Customized basis1d
ggt1d <- ggtour(mt_path1d, dat, angle = .3) +
  proto_density() +
  proto_basis1d(position     = "bottom",
                manip_col    = "pink",
                segment_size = 3,
                text_size    = 6,
                text_offset  = 1.2)
\donttest{
animate_plotly(ggt1d)
}
}
\seealso{
Other ggtour proto functions: 
\code{\link{append_fixed_y}()},
\code{\link{facet_wrap_tour}()},
\code{\link{ggtour}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_density2d}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_hline0}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto functions}
