% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{sptrun}
\alias{sptrun}
\title{Truncation of a Region of a Mid-Infrared Spectral Matrix}
\usage{
sptrun(spectra, limInf, limSup)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}

\item{limInf}{numeric. Upper wavenumber limit of the spectral region.}

\item{limSup}{numeric. Lower wavenumber limit of the spectral region.}
}
\value{
A truncated matrix within two wavenumber limits. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.
}
\description{
Allow to trim a region of the spectra defined between two wavenumbers.
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# Truncated
trn <- sptrun(spectra=spectra, limInf=800, limSup=2000)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

