/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.accept;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.DockAcceptance;
import java.util.ArrayList;
import java.util.List;

public class MultiDockAcceptance
implements DockAcceptance {
    private List<DockAcceptance> acceptances = new ArrayList<DockAcceptance>();

    public void add(DockAcceptance acceptance) {
        if (acceptance == null) {
            throw new IllegalArgumentException("Acceptance must not be null");
        }
        this.acceptances.add(acceptance);
    }

    public void remove(DockAcceptance acceptance) {
        this.acceptances.remove(acceptance);
    }

    public boolean accept(DockStation parent, Dockable child) {
        for (DockAcceptance acceptance : this.acceptances) {
            if (acceptance.accept(parent, child)) continue;
            return false;
        }
        return true;
    }

    public boolean accept(DockStation parent, Dockable child, Dockable next) {
        for (DockAcceptance acceptance : this.acceptances) {
            if (acceptance.accept(parent, child, next)) continue;
            return false;
        }
        return true;
    }
}

