/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import java.awt.Dimension;

public abstract class AbstractTab
extends AbstractTabPaneComponent
implements Tab {
    private Dockable dockable;
    private boolean bound = false;
    private DockController controller;
    private boolean selected = false;
    private boolean focused = false;
    private TabPaneListener selectionListener = new TabPaneListener(){

        public void added(TabPane pane, Dockable dockable) {
        }

        public void removed(TabPane pane, Dockable dockable) {
        }

        public void selectionChanged(TabPane pane) {
            boolean newSelected;
            boolean bl = newSelected = pane.getSelectedDockable() == AbstractTab.this.getDockable();
            if (newSelected != AbstractTab.this.selected) {
                AbstractTab.this.selected = newSelected;
                AbstractTab.this.informSelectionChanged(AbstractTab.this.selected);
            }
        }

        public void infoComponentChanged(TabPane pane, LonelyTabPaneComponent oldInfo, LonelyTabPaneComponent newInfo) {
        }
    };
    private DockableFocusListener focusListener = new DockableFocusListener(){

        public void dockableFocused(DockableFocusEvent event) {
            boolean newFocused;
            boolean bl = newFocused = event.getNewFocusOwner() == AbstractTab.this.getDockable();
            if (newFocused != AbstractTab.this.focused) {
                AbstractTab.this.focused = newFocused;
                AbstractTab.this.informFocusChanged(AbstractTab.this.focused);
            }
        }
    };

    public AbstractTab(TabPane parent, Dockable dockable) {
        super(parent);
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.dockable = dockable;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public Dimension getMinimumSize(Tab[] tabs) {
        return this.getMinimumSize();
    }

    public Dimension getPreferredSize(Tab[] tabs) {
        return this.getPreferredSize();
    }

    public void bind() {
        if (this.bound) {
            throw new IllegalStateException("this tab is already bound");
        }
        this.bound = true;
        if (this.controller != null) {
            this.controller.addDockableFocusListener(this.focusListener);
            this.focused = this.controller.getFocusedDockable() == this.getDockable();
            this.informFocusChanged(this.focused);
        }
        TabPane parent = this.getTabParent();
        parent.addTabPaneListener(this.selectionListener);
        this.selected = parent.getSelectedDockable() == this.getDockable();
        this.informSelectionChanged(this.selected);
    }

    public void unbind() {
        if (!this.bound) {
            throw new IllegalStateException("this tab is not bound");
        }
        this.bound = false;
        if (this.controller != null) {
            this.controller.removeDockableFocusListener(this.focusListener);
        }
        this.getTabParent().removeTabPaneListener(this.selectionListener);
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected abstract void informSelectionChanged(boolean var1);

    public boolean isFocused() {
        return this.focused;
    }

    protected abstract void informFocusChanged(boolean var1);

    public void setController(DockController controller) {
        if (this.bound) {
            if (this.controller != null) {
                this.controller.removeDockableFocusListener(this.focusListener);
            }
            this.controller = controller;
            if (this.controller != null) {
                this.controller.addDockableFocusListener(this.focusListener);
                this.focused = this.controller.getFocusedDockable() == this.getDockable();
                this.informFocusChanged(this.focused);
            }
        } else {
            this.controller = controller;
        }
    }
}

