/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.extension;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.extension.Extension;
import bibliothek.gui.dock.util.extension.ExtensionName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManager {
    private DockController controller;
    private List<Extension> extensions = new ArrayList<Extension>();
    private boolean alive = false;

    public ExtensionManager(DockController controller) {
        this.controller = controller;
        this.tryLoadDefaultExtensions();
    }

    protected void tryLoadDefaultExtensions() {
        String[] list;
        for (String className : list = new String[]{"glass.eclipse.GlassExtension"}) {
            try {
                this.tryLoadExtension(className);
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    private void tryLoadExtension(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(className);
        Object extension = clazz.newInstance();
        if (extension instanceof Extension) {
            this.add((Extension)extension);
        }
    }

    public void add(Extension extension) {
        this.extensions.add(extension);
        if (this.alive) {
            extension.install(this.controller);
        }
    }

    public void remove(Extension extension) {
        if (this.extensions.remove(extension) && this.alive) {
            extension.uninstall(this.controller);
        }
    }

    public Extension[] getExtensions() {
        return this.extensions.toArray(new Extension[this.extensions.size()]);
    }

    public <E> List<E> load(ExtensionName<E> name) {
        ArrayList<E> result = new ArrayList<E>();
        for (Extension extension : this.extensions) {
            Collection<E> es = extension.load(this.controller, name);
            if (es == null) continue;
            result.addAll(es);
        }
        return result;
    }

    public void init() {
        this.alive = true;
        for (Extension extension : this.extensions) {
            extension.install(this.controller);
        }
    }

    public void kill() {
        if (this.alive) {
            this.alive = false;
            for (Extension extension : this.extensions) {
                extension.uninstall(this.controller);
            }
            this.extensions.clear();
        }
    }
}

