/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.DirectRemoteRelocator;
import bibliothek.gui.dock.control.DockRelocatorMode;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.event.DockRelocatorListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class DockRelocator {
    private List<DockRelocatorListener> listeners = new ArrayList<DockRelocatorListener>();
    private DockController controller;
    private int dragDistance = 10;
    private boolean dragOnlyTitel = false;
    private List<DockRelocatorMode> modes = new ArrayList<DockRelocatorMode>();
    private Set<DockRelocatorMode> activeModes = new HashSet<DockRelocatorMode>();
    private Merger merger = null;

    public DockRelocator(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
    }

    public DockController getController() {
        return this.controller;
    }

    public void addDockRelocatorListener(DockRelocatorListener listener) {
        this.listeners.add(listener);
    }

    public void removeDockRelocatorListener(DockRelocatorListener listener) {
        this.listeners.remove(listener);
    }

    protected DockRelocatorListener[] listListeners() {
        return this.listeners.toArray(new DockRelocatorListener[this.listeners.size()]);
    }

    protected void fireInit(Dockable dockable) {
        for (DockRelocatorListener listener : this.listListeners()) {
            listener.init(this.controller, dockable);
        }
    }

    protected void fireCancel(Dockable dockable) {
        for (DockRelocatorListener listener : this.listListeners()) {
            listener.cancel(this.controller, dockable);
        }
    }

    protected void fireDrag(Dockable dockable, DockStation station) {
        for (DockRelocatorListener listener : this.listListeners()) {
            listener.drag(this.controller, dockable, station);
        }
    }

    protected void fireDrop(Dockable dockable, DockStation station) {
        for (DockRelocatorListener listener : this.listListeners()) {
            listener.drop(this.controller, dockable, station);
        }
    }

    public boolean isDragOnlyTitel() {
        return this.dragOnlyTitel;
    }

    public void setDragOnlyTitel(boolean dragOnlyTitel) {
        this.dragOnlyTitel = dragOnlyTitel;
    }

    public int getDragDistance() {
        return this.dragDistance;
    }

    public void setDragDistance(int dragDistance) {
        this.dragDistance = dragDistance;
    }

    public Merger getMerger() {
        return this.merger;
    }

    public void setMerger(Merger merger) {
        this.merger = merger;
    }

    public void addMode(DockRelocatorMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode must not be null");
        }
        this.modes.add(mode);
    }

    public void removeMode(DockRelocatorMode mode) {
        if (this.activeModes.remove(mode)) {
            mode.setActive(this.controller, false);
        }
        this.modes.remove(mode);
    }

    protected void disableAllModes() {
        for (DockRelocatorMode mode : this.activeModes) {
            mode.setActive(this.controller, false);
        }
        this.activeModes.clear();
    }

    protected void checkModes(int modifiers) {
        for (DockRelocatorMode mode : this.modes) {
            boolean active = mode.shouldBeActive(this.controller, modifiers);
            if (active) {
                if (!this.activeModes.add(mode)) continue;
                mode.setActive(this.controller, true);
                continue;
            }
            if (!this.activeModes.remove(mode)) continue;
            mode.setActive(this.controller, false);
        }
    }

    public abstract boolean isOnMove();

    public abstract boolean isOnPut();

    public abstract DirectRemoteRelocator createDirectRemote(Dockable var1);

    public abstract DirectRemoteRelocator createDirectRemote(Dockable var1, boolean var2);

    public abstract RemoteRelocator createRemote(Dockable var1);

    public abstract RemoteRelocator createRemote(Dockable var1, boolean var2);
}

