/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;

public class DockHierarchyLock {
    private volatile Token token = null;
    private boolean hardExceptions = false;
    private volatile int concurrent = 0;

    public void setHardExceptions(boolean hardExceptions) {
        this.hardExceptions = hardExceptions;
    }

    public boolean isHardExceptions() {
        return this.hardExceptions;
    }

    public synchronized void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent ? ++this.concurrent : --this.concurrent;
    }

    public boolean isConcurrent() {
        return this.concurrent > 0;
    }

    public static Token acquireLinking(DockStation station, Dockable dockable) {
        DockController controller = station.getController();
        if (controller == null) {
            return new Token(null, station, dockable, true);
        }
        return controller.getHierarchyLock().acquireLink(station, dockable);
    }

    public static Token acquireUnlinking(DockStation station, Dockable dockable) {
        DockController controller = station.getController();
        if (controller == null) {
            return new Token(null, station, dockable, true);
        }
        return controller.getHierarchyLock().acquireUnlink(station, dockable);
    }

    public static Token acquireFake() {
        return new Token(null, null, null, false);
    }

    public synchronized Token acquireLink(DockStation station, Dockable dockable) {
        if (station == null) {
            throw new IllegalArgumentException("station is null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        this.ensureUnlinked(station, dockable);
        if (this.isConcurrent()) {
            return new Token(this, station, dockable, true);
        }
        if (this.token != null) {
            this.throwException(new IllegalStateException("the lock has already been acquired"));
        }
        this.token = new Token(this, station, dockable, true);
        return this.token;
    }

    public synchronized Token acquireUnlink(DockStation station, Dockable dockable) {
        if (station == null) {
            throw new IllegalArgumentException("station is null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        this.ensureLinked(station, dockable);
        if (this.isConcurrent()) {
            return new Token(this, station, dockable, false);
        }
        if (this.token != null) {
            this.throwException(new IllegalStateException("the lock has already been acquired"));
        }
        this.token = new Token(this, station, dockable, false);
        return this.token;
    }

    private void ensureLinked(DockStation station, Dockable dockable) {
        if (dockable.getDockParent() != station) {
            this.throwException(new IllegalStateException("the parent of '" + dockable + "' is not '" + station + "' but '" + dockable.getDockParent() + "'"));
            return;
        }
        boolean found = false;
        int n = station.getDockableCount();
        for (int i = 0; i < n && !found; ++i) {
            if (station.getDockable(i) != dockable) continue;
            found = true;
        }
        if (!found) {
            this.throwException(new IllegalStateException("the station '" + station + "' does not know '" + dockable + "'"));
            return;
        }
    }

    private void ensureUnlinked(DockStation station, Dockable dockable) {
        if (dockable.getDockParent() != null) {
            this.throwException(new IllegalStateException("The parent of '" + dockable + "' is not null but '" + dockable.getDockParent() + "'"));
            return;
        }
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            if (station.getDockable(i) != dockable) continue;
            this.throwException(new IllegalStateException("The station '" + station + "' knows of '" + dockable + "'"));
            return;
        }
    }

    private void throwException(RuntimeException exception) {
        if (this.hardExceptions) {
            throw exception;
        }
        exception.printStackTrace();
    }

    public static class Token {
        private DockHierarchyLock lock;
        private DockStation station;
        private Dockable dockable;
        private boolean link;

        private Token(DockHierarchyLock lock, DockStation station, Dockable dockable, boolean link) {
            this.lock = lock;
            this.station = station;
            this.dockable = dockable;
            this.link = link;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Token token = this;
            synchronized (token) {
                if (this.lock != null) {
                    this.lock.token = null;
                    if (this.link) {
                        this.lock.ensureLinked(this.station, this.dockable);
                    } else {
                        this.lock.ensureUnlinked(this.station, this.dockable);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseNoCheck() {
            Token token = this;
            synchronized (token) {
                if (this.lock != null) {
                    this.lock.token = null;
                }
            }
        }
    }
}

