/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.menu;

import bibliothek.extension.gui.dock.preference.DefaultPreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceDialog;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceTreeDialog;
import bibliothek.extension.gui.dock.preference.PreferenceTreeModel;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CPreferenceModel;
import bibliothek.gui.dock.facile.menu.MenuPieceText;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class CPreferenceMenuPiece
extends BaseMenuPiece {
    private MenuPieceText text;
    private CControl control;
    private PreferenceModel model;
    private AbstractAction action = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            CPreferenceMenuPiece.this.action();
        }
    };

    public static CPreferenceMenuPiece setup(CControl control) {
        if (control.getPreferenceModel() == null) {
            control.setPreferenceModel(new CPreferenceModel(control));
        }
        return new CPreferenceMenuPiece(control);
    }

    public CPreferenceMenuPiece(CControl control) {
        if (control == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = control;
        this.text = new MenuPieceText("PreferenceMenuPiece.text", this){

            protected void changed(String oldValue, String newValue) {
                CPreferenceMenuPiece.this.action.putValue("Name", newValue);
            }
        };
        this.add(new JMenuItem(this.action));
    }

    public void bind() {
        super.bind();
        this.text.setController(this.control.getController());
    }

    public void unbind() {
        super.unbind();
        this.text.setController(null);
    }

    public void setModel(PreferenceModel model) {
        this.model = model;
    }

    public PreferenceModel getModel() {
        return this.model;
    }

    protected void action() {
        PreferenceModel model = this.model;
        if (model == null) {
            model = this.control.getPreferenceModel();
        }
        if (model == null) {
            model = new DefaultPreferenceModel(this.control.getController());
        }
        Window owner = this.control.intern().getController().findRootWindow();
        this.control.getPreferences().load(model, false);
        if (model instanceof PreferenceTreeModel) {
            PreferenceTreeDialog.openDialog((PreferenceTreeModel)model, owner);
        } else {
            PreferenceDialog.openDialog(model, owner);
        }
        this.control.getPreferences().store(model);
    }
}

