/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Setting {
    private Map<String, DockLayoutComposition> roots = new HashMap<String, DockLayoutComposition>();
    private List<Invisible> dockables = new ArrayList<Invisible>();

    public void putRoot(String string, DockLayoutComposition dockLayoutComposition) {
        this.roots.put(string, dockLayoutComposition);
    }

    public DockLayoutComposition getRoot(String string) {
        return this.roots.get(string);
    }

    public String[] getRootKeys() {
        Set<String> set = this.roots.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void addInvisible(String string, String string2, DockLayoutComposition dockLayoutComposition, DockableProperty dockableProperty) {
        Invisible invisible = new Invisible();
        invisible.key = string;
        invisible.root = string2;
        invisible.location = dockableProperty;
        invisible.layout = dockLayoutComposition;
        this.dockables.add(invisible);
    }

    public int getInvisibleCount() {
        return this.dockables.size();
    }

    public String getInvisibleKey(int n) {
        return this.dockables.get((int)n).key;
    }

    public String getInvisibleRoot(int n) {
        return this.dockables.get((int)n).root;
    }

    public DockableProperty getInvisibleLocation(int n) {
        return this.dockables.get((int)n).location;
    }

    public DockLayoutComposition getInvisibleLayout(int n) {
        return this.dockables.get((int)n).layout;
    }

    public void fillMissing(DockSituation dockSituation) {
        try {
            for (Map.Entry<String, DockLayoutComposition> entry : this.roots.entrySet()) {
                entry.setValue(dockSituation.fillMissing(entry.getValue()));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
        catch (XException xException) {
            throw new IllegalArgumentException(xException);
        }
    }

    public void write(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_7);
        String[] stringArray = this.getRootKeys();
        dataOutputStream.writeInt(stringArray.length);
        for (String object : stringArray) {
            dataOutputStream.writeUTF(object);
            dockSituation.writeComposition(this.getRoot(object), dataOutputStream);
        }
        dataOutputStream.writeInt(this.getInvisibleCount());
        int n = this.getInvisibleCount();
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeUTF(this.getInvisibleKey(i));
            String string = this.getInvisibleRoot(i);
            if (string == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeUTF(string);
            }
            DockableProperty dockableProperty = this.getInvisibleLocation(i);
            if (dockableProperty == null) {
                dataOutputStream.writeBoolean(false);
            } else {
                dataOutputStream.writeBoolean(true);
                propertyTransformer.write(this.getInvisibleLocation(i), dataOutputStream);
            }
            DockLayoutComposition dockLayoutComposition = this.getInvisibleLayout(i);
            if (dockLayoutComposition == null) {
                dataOutputStream.writeBoolean(false);
                continue;
            }
            dataOutputStream.writeBoolean(true);
            dockSituation.writeComposition(dockLayoutComposition, dataOutputStream);
        }
    }

    public void writeXML(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, XElement xElement) {
        Object object;
        XElement xElement2 = xElement.addElement("roots");
        String[] stringArray = this.getRootKeys();
        for (String object2 : stringArray) {
            object = xElement2.addElement("root");
            ((XElement)object).addString("name", object2);
            dockSituation.writeCompositionXML(this.getRoot(object2), (XElement)object);
        }
        XElement xElement3 = xElement.addElement("children");
        int n = this.getInvisibleCount();
        for (int i = 0; i < n; ++i) {
            DockableProperty dockableProperty;
            XElement xElement4 = xElement3.addElement("child");
            xElement4.addString("key", this.getInvisibleKey(i));
            object = this.getInvisibleRoot(i);
            if (object != null) {
                xElement4.addString("root", (String)object);
            }
            if ((dockableProperty = this.getInvisibleLocation(i)) == null) {
                xElement4.addBoolean("location", false);
            } else {
                xElement4.addBoolean("location", true);
                propertyTransformer.writeXML(this.getInvisibleLocation(i), xElement4.addElement("location"));
            }
            DockLayoutComposition dockLayoutComposition = this.getInvisibleLayout(i);
            if (dockLayoutComposition == null) continue;
            dockSituation.writeCompositionXML(dockLayoutComposition, xElement4.addElement("layout"));
        }
    }

    public void read(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, DataInputStream dataInputStream) throws IOException {
        Object object;
        String string;
        int n;
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl2 = Version.VERSION_1_0_7.compareTo(version) <= 0;
        this.roots.clear();
        this.dockables.clear();
        int n2 = dataInputStream.readInt();
        for (n = 0; n < n2; ++n) {
            string = dataInputStream.readUTF();
            object = dockSituation.readComposition(dataInputStream);
            if (object == null) continue;
            this.putRoot(string, (DockLayoutComposition)object);
        }
        n2 = dataInputStream.readInt();
        for (n = 0; n < n2; ++n) {
            string = dataInputStream.readUTF();
            object = null;
            if (bl2) {
                if (dataInputStream.readBoolean()) {
                    object = dataInputStream.readUTF();
                }
            } else {
                object = dataInputStream.readUTF();
            }
            DockableProperty dockableProperty = null;
            if (bl2) {
                if (dataInputStream.readBoolean()) {
                    dockableProperty = propertyTransformer.read(dataInputStream);
                }
            } else {
                dockableProperty = propertyTransformer.read(dataInputStream);
            }
            DockLayoutComposition dockLayoutComposition = null;
            if (bl2 && dataInputStream.readBoolean()) {
                dockLayoutComposition = dockSituation.readComposition(dataInputStream);
            }
            this.addInvisible(string, (String)object, dockLayoutComposition, dockableProperty);
        }
    }

    public void readXML(DockSituation dockSituation, PropertyTransformer propertyTransformer, boolean bl, XElement xElement) {
        Object object;
        Object object2;
        this.roots.clear();
        this.dockables.clear();
        XElement xElement2 = xElement.getElement("roots");
        if (xElement2 != null) {
            object2 = xElement2.getElements("root");
            int n = ((XElement[])object2).length;
            for (int i = 0; i < n; ++i) {
                Object object3 = object2[i];
                String object4 = ((XElement)object3).getString("name");
                object = dockSituation.readCompositionXML((XElement)object3);
                if (object == null) continue;
                this.putRoot(object4, (DockLayoutComposition)object);
            }
        }
        if ((object2 = xElement.getElement("children")) != null) {
            for (XElement xElement3 : ((XElement)object2).getElements("child")) {
                object = xElement3.getString("key");
                String string = null;
                XAttribute xAttribute = xElement3.getAttribute("root");
                if (xAttribute != null) {
                    string = xAttribute.getString();
                }
                boolean bl2 = true;
                boolean bl3 = false;
                XAttribute xAttribute2 = xElement3.getAttribute("location");
                if (xAttribute2 != null) {
                    bl2 = false;
                    bl3 = xAttribute2.getBoolean();
                }
                DockableProperty dockableProperty = null;
                DockLayoutComposition dockLayoutComposition = null;
                if (bl2) {
                    dockableProperty = propertyTransformer.readXML(xElement3);
                } else {
                    XElement xElement4;
                    if (bl3) {
                        xElement4 = xElement3.getElement("location");
                        dockableProperty = propertyTransformer.readXML(xElement4);
                    }
                    if ((xElement4 = xElement3.getElement("layout")) != null) {
                        dockLayoutComposition = dockSituation.readCompositionXML(xElement4);
                    }
                }
                this.addInvisible((String)object, string, dockLayoutComposition, dockableProperty);
            }
        }
    }

    private static class Invisible {
        public String key;
        public String root;
        public DockableProperty location;
        public DockLayoutComposition layout;

        private Invisible() {
        }
    }
}

