/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import javax.swing.JComponent;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScrollableSizeHint {
    NONE(false),
    FIT(true),
    HORIZONTAL_STRETCH(0){

        boolean isSmallerThanParent(JComponent component) {
            if (component.getParent() != null) {
                return component.getParent().getWidth() > component.getPreferredSize().width;
            }
            return false;
        }
    }
    ,
    VERTICAL_STRETCH(1){

        boolean isSmallerThanParent(JComponent component) {
            if (component.getParent() != null) {
                return component.getParent().getHeight() > component.getPreferredSize().height;
            }
            return false;
        }
    };

    final boolean tracks;
    final int orientation;

    private ScrollableSizeHint(boolean track) {
        this(track, -1);
    }

    private ScrollableSizeHint(int orientation) {
        this(false, orientation);
    }

    private ScrollableSizeHint(boolean tracks, int orientation) {
        this.tracks = tracks;
        this.orientation = orientation;
    }

    public boolean getTracksParentSize(JComponent component) {
        Contract.asNotNull(component, "component must be not-null");
        if (this.orientation < 0) {
            return this.tracks;
        }
        return this.isSmallerThanParent(component);
    }

    public boolean isHorizontalCompatible() {
        return this.orientation < 0 ? true : 0 == this.orientation;
    }

    public boolean isVerticalCompatible() {
        return this.orientation < 0 ? true : 1 == this.orientation;
    }

    boolean isSmallerThanParent(JComponent component) {
        return this.tracks;
    }
}

