% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralNMF.R
\name{spectralNMF}
\alias{spectralNMF}
\title{Perform Non-Negative Matrix factorization on spectral data}
\usage{
spectralNMF(
  object,
  rank,
  method = "PGNMF",
  initSpectralData = NULL,
  nruns = 10,
  subsamplingFactor = 1,
  checkDivergence = TRUE,
  maxIter = 1000,
  includeRefs = FALSE
)
}
\arguments{
\item{object}{\code{\link{SpectraInTime-class}}}

\item{rank}{number of NMF components to be found}

\item{method}{name of the NMF method to be used. "PGNMF" (default), "HALSacc" 
and "semiNMF" are methods derived from the hNMF package. All methods from the NMF package are also available.}

\item{initSpectralData}{this can be a list of spectralData objects, containing 
the pure component spectra. It can also be either of the NMF factor matrices with initial values}

\item{nruns}{number of NMF runs. It is recommended to run the NMF analyses multiple
times when random seeding is used, to avoid a suboptimal solution}

\item{subsamplingFactor}{subsampling factor used during NMF analysis}

\item{checkDivergence}{Boolean indicating whether divergence checking should be performed}

\item{maxIter}{maximum number of iterations per NMF run}

\item{includeRefs}{boolean, indicating whether references should be included in the input matrix for the NMF analysis}
}
\value{
\code{\link{SpectraInTimeComp-class}} which includeds a scaled NMF model (in accordance with the NMF package definition)

\code{\link{SpectraInTimeComp-class}}
}
\description{
Perform Non-Negative Matrix factorization on spectral data
}
\examples{
\donttest{
 spectralExample    <-  getSpectraInTimeExample()
 nmfResult          <-  spectralNMF( spectralExample , rank = 2 , subsamplingFactor = 5 )
  nmfObject         <-  getDimensionReduction( nmfResult , type = "NMF")$NMF
  nmfTrends         <-  t( NMF::coef( nmfObject ) )
  matplot( nmfTrends , type = "l" , x = getTimePoints( spectralExample , timeUnit = "hours"  ),
		 xlab = "time in hours"  )
}
}
\author{
Nicolas Sauwen
}
