% Copyright 2002 by Roger S. Bivand
\name{eire}
\alias{eire}
\alias{eire.df}
\alias{eire.polys.utm}
\alias{eire.coords.utm}
\alias{eire.bbs.utm}
\alias{eire.nb}
\non_function{}
\title{Eire data sets}
\usage{data(eire)}
\description{
The \code{eire.df} data frame has 26 rows and 9 columns. In addition,
polygons of the 26 counties are provided as a multipart polylist in
eire.polys.utm (coordinates in km, projection UTM zone 30). Their
centroids are in eire.coords.utm, and their bounding boxes in
eire.bbs.utm. The original Cliff and Ord binary contiguities are in
eire.nb.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{A}{Percentage of sample with blood group A}
    \item{towns}{Towns/unit area}
    \item{pale}{Beyond the Pale 0, within the Pale 1}
    \item{size}{number of blood type samples}
    \item{ROADACC}{arterial road network accessibility in 1961}
    \item{OWNCONS}{percentage in value terms of gross agricultural output of 
each county consumed by itself}
    \item{POPCHG}{1961 population as percentage of 1926}
    \item{RETSALE}{value of retail sales 000}
    \item{INCOME}{total personal income 000}
  }
}
\source{Upton and Fingleton 1985, - Bailey and Gatrell 1995, ch. 1 for blood 
group data, Cliff and Ord (1973), p. 107 for remaining variables (also after 
O'Sullivan, 1968). Polygon borders and Irish data sourced from Michael
Tiefelsdorf's SPSS Saddlepoint bundle:
\url{http://geog-www.sbs.ohio-state.edu/faculty/tiefelsdorf/GeoStat.htm}.
}
\examples{
data(eire)
% Eire physical anthropology blood group data
summary(eire.df$A)
brks <- round(fivenum(eire.df$A), digits=2)
cols <- rev(heat.colors(4))
plotpolys(eire.polys.utm, eire.bbs.utm,
 col=cols[findInterval2(eire.df$A, brks)])
title(main="Percentage with blood group A in Eire")
legend(x=c(-50, 70), y=c(6120, 6050), leglabs(brks), fill=cols, bty="n")
plotpolys(eire.polys.utm, eire.bbs.utm)
plot(eire.nb, eire.coords.utm, add=TRUE)
lA <- lag.listw(nb2listw(eire.nb), eire.df$A)
summary(lA)
moran.test(spNamedVec("A", eire.df), nb2listw(eire.nb))
geary.test(spNamedVec("A", eire.df), nb2listw(eire.nb))
cor(lA, eire.df$A)
moran.plot(spNamedVec("A", eire.df), nb2listw(eire.nb),
 labels=rownames(eire.df))
A.lm <- lm(A ~ towns + pale, data=eire.df)
summary(A.lm)
res <- residuals(A.lm)
brks <- c(min(res),-2,-1,0,1,2,max(res))
cols <- rev(cm.colors(6))
plotpolys(eire.polys.utm, eire.bbs.utm, col=cols[findInterval2(res, brks)])
title(main="Regression residuals")
legend(x=c(-50, 70), y=c(6120, 6050), legend=leglabs(brks), fill=cols,
  bty="n")
lm.morantest(A.lm, nb2listw(eire.nb))
lm.morantest.sad(A.lm, nb2listw(eire.nb))
lm.LMtests(A.lm, nb2listw(eire.nb), test="LMerr")
% Eire agricultural data
brks <- round(fivenum(eire.df$OWNCONS), digits=2)
cols <- grey(4:1/5)
plotpolys(eire.polys.utm, eire.bbs.utm,
 col=cols[findInterval2(eire.df$OWNCONS, brks)])
title(main="Percentage own consumption of agricultural produce")
legend(x=c(-50, 70), y=c(6120, 6050), legend=leglabs(brks),
  fill=cols, bty="n")
moran.plot(spNamedVec("OWNCONS", eire.df), nb2listw(eire.nb))
moran.test(spNamedVec("OWNCONS", eire.df), nb2listw(eire.nb))
e.lm <- lm(OWNCONS ~ ROADACC, data=eire.df)
res <- residuals(e.lm)
brks <- c(min(res),-2,-1,0,1,2,max(res))
cols <- rev(cm.colors(6))
plotpolys(eire.polys.utm, eire.bbs.utm, col=cols[findInterval2(res, brks)])
title(main="Regression residuals")
legend(x=c(-50, 70), y=c(6120, 6050), legend=leglabs(brks), fill=cm.colors(6),
  bty="n")
lm.morantest(e.lm, nb2listw(eire.nb))
lm.morantest.sad(e.lm, nb2listw(eire.nb))
lm.LMtests(e.lm, nb2listw(eire.nb), test="LMerr")
print(localmoran.sad(e.lm, eire.nb, select=1:nrow(eire.df)))
}
\keyword{datasets}
